/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.accumulo;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.log4j.Logger;
import org.apache.rya.accumulo.utils.RyaTableNames;
import org.apache.rya.api.client.InstanceDoesNotExistException;
import org.apache.rya.api.client.InstanceExists;
import org.apache.rya.api.client.RyaClientException;
import org.apache.rya.api.client.Uninstall;
import org.apache.rya.api.client.accumulo.AccumuloCommand;
import org.apache.rya.api.client.accumulo.AccumuloConnectionDetails;
import org.apache.rya.api.client.accumulo.AccumuloInstanceExists;
import org.apache.rya.api.instance.RyaDetailsRepository;
import org.apache.rya.api.log.LogUtils;
import org.apache.rya.indexing.pcj.storage.PrecomputedJoinStorage;

@DefaultAnnotation(value={NonNull.class})
public class AccumuloUninstall
extends AccumuloCommand
implements Uninstall {
    private static final Logger log = Logger.getLogger(AccumuloUninstall.class);
    private final InstanceExists instanceExists;

    public AccumuloUninstall(AccumuloConnectionDetails connectionDetails, Connector connector) {
        super(connectionDetails, connector);
        this.instanceExists = new AccumuloInstanceExists(connectionDetails, connector);
    }

    public void uninstall(String ryaInstanceName) throws InstanceDoesNotExistException, RyaClientException {
        Objects.requireNonNull(ryaInstanceName);
        if (!this.instanceExists.exists(ryaInstanceName)) {
            throw new InstanceDoesNotExistException(String.format("There is no Rya instance named '%s'.", ryaInstanceName));
        }
        try {
            List<String> tables = new RyaTableNames().getTableNames(ryaInstanceName, this.getConnector());
            TableOperations tableOps = this.getConnector().tableOperations();
            for (String table : tables) {
                try {
                    tableOps.delete(table);
                }
                catch (TableNotFoundException e) {
                    log.warn((Object)("Uninstall could not delete table named '" + LogUtils.clean((String)table) + "' because it does not exist. Something else is also deleting tables."));
                }
            }
        }
        catch (RyaDetailsRepository.RyaDetailsRepositoryException | PrecomputedJoinStorage.PCJStorageException e) {
            throw new RyaClientException("Could not uninstall the Rya instance named '" + ryaInstanceName + "' because we could not determine which tables are associated with it.", e);
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new RyaClientException("Could not uninstall the Rya instance named '" + ryaInstanceName + "' because of a problem interacting with Accumulo..", e);
        }
    }
}

