/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.accumulo;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import org.apache.accumulo.core.client.Connector;
import org.apache.rya.api.client.BatchUpdatePCJ;
import org.apache.rya.api.client.CreatePCJ;
import org.apache.rya.api.client.DeletePCJ;
import org.apache.rya.api.client.ExecuteSparqlQuery;
import org.apache.rya.api.client.GetInstanceDetails;
import org.apache.rya.api.client.Install;
import org.apache.rya.api.client.InstanceExists;
import org.apache.rya.api.client.ListInstances;
import org.apache.rya.api.client.LoadStatements;
import org.apache.rya.api.client.LoadStatementsFile;
import org.apache.rya.api.client.RyaClient;
import org.apache.rya.api.client.SetRyaStreamsConfiguration;
import org.apache.rya.api.client.Uninstall;
import org.apache.rya.api.client.accumulo.AccumuloAddUser;
import org.apache.rya.api.client.accumulo.AccumuloBatchUpdatePCJ;
import org.apache.rya.api.client.accumulo.AccumuloConnectionDetails;
import org.apache.rya.api.client.accumulo.AccumuloCreatePCJ;
import org.apache.rya.api.client.accumulo.AccumuloCreatePeriodicPCJ;
import org.apache.rya.api.client.accumulo.AccumuloDeletePCJ;
import org.apache.rya.api.client.accumulo.AccumuloDeletePeriodicPCJ;
import org.apache.rya.api.client.accumulo.AccumuloExecuteSparqlQuery;
import org.apache.rya.api.client.accumulo.AccumuloGetInstanceDetails;
import org.apache.rya.api.client.accumulo.AccumuloInstall;
import org.apache.rya.api.client.accumulo.AccumuloInstanceExists;
import org.apache.rya.api.client.accumulo.AccumuloListIncrementalQueries;
import org.apache.rya.api.client.accumulo.AccumuloListInstances;
import org.apache.rya.api.client.accumulo.AccumuloLoadStatements;
import org.apache.rya.api.client.accumulo.AccumuloLoadStatementsFile;
import org.apache.rya.api.client.accumulo.AccumuloRemoveUser;
import org.apache.rya.api.client.accumulo.AccumuloSetRyaStreamsConfiguration;
import org.apache.rya.api.client.accumulo.AccumuloUninstall;

@DefaultAnnotation(value={NonNull.class})
public class AccumuloRyaClientFactory {
    public static RyaClient build(AccumuloConnectionDetails connectionDetails, Connector connector) {
        Objects.requireNonNull(connectionDetails);
        Objects.requireNonNull(connector);
        AccumuloInstanceExists instanceExists = new AccumuloInstanceExists(connectionDetails, connector);
        return new RyaClient((Install)new AccumuloInstall(connectionDetails, connector), (CreatePCJ)new AccumuloCreatePCJ(connectionDetails, connector), (DeletePCJ)new AccumuloDeletePCJ(connectionDetails, connector), Optional.of(new AccumuloCreatePeriodicPCJ(connectionDetails, connector)), Optional.of(new AccumuloDeletePeriodicPCJ(connectionDetails, connector)), Optional.of(new AccumuloListIncrementalQueries(connectionDetails, connector)), (BatchUpdatePCJ)new AccumuloBatchUpdatePCJ(connectionDetails, connector), (GetInstanceDetails)new AccumuloGetInstanceDetails(connectionDetails, connector), (InstanceExists)instanceExists, (ListInstances)new AccumuloListInstances(connectionDetails, connector), Optional.of(new AccumuloAddUser(connectionDetails, connector)), Optional.of(new AccumuloRemoveUser(connectionDetails, connector)), (SetRyaStreamsConfiguration)new AccumuloSetRyaStreamsConfiguration(instanceExists, connector), (Uninstall)new AccumuloUninstall(connectionDetails, connector), (LoadStatements)new AccumuloLoadStatements(connectionDetails, connector), (LoadStatementsFile)new AccumuloLoadStatementsFile(connectionDetails, connector), (ExecuteSparqlQuery)new AccumuloExecuteSparqlQuery(connectionDetails, connector));
    }
}

