/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.accumulo;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.rya.accumulo.instance.AccumuloRyaInstanceDetailsRepository;
import org.apache.rya.accumulo.utils.RyaTableNames;
import org.apache.rya.accumulo.utils.TablePermissions;
import org.apache.rya.api.client.InstanceDoesNotExistException;
import org.apache.rya.api.client.RemoveUser;
import org.apache.rya.api.client.RyaClientException;
import org.apache.rya.api.client.accumulo.AccumuloCommand;
import org.apache.rya.api.client.accumulo.AccumuloConnectionDetails;
import org.apache.rya.api.instance.RyaDetails;
import org.apache.rya.api.instance.RyaDetailsRepository;
import org.apache.rya.api.instance.RyaDetailsUpdater;
import org.apache.rya.indexing.pcj.storage.PrecomputedJoinStorage;

@DefaultAnnotation(value={NonNull.class})
public class AccumuloRemoveUser
extends AccumuloCommand
implements RemoveUser {
    private static final TablePermissions TABLE_PERMISSIONS = new TablePermissions();

    public AccumuloRemoveUser(AccumuloConnectionDetails connectionDetails, Connector connector) {
        super(connectionDetails, connector);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeUser(String instanceName, String username) throws InstanceDoesNotExistException, RyaClientException {
        Objects.requireNonNull(instanceName);
        Objects.requireNonNull(username);
        RyaDetailsUpdater updater = new RyaDetailsUpdater((RyaDetailsRepository)new AccumuloRyaInstanceDetailsRepository(this.getConnector(), instanceName));
        try {
            updater.update(originalDetails -> RyaDetails.builder((RyaDetails)originalDetails).removeUser(username).build());
        }
        catch (RyaDetailsRepository.RyaDetailsRepositoryException | RyaDetailsUpdater.RyaDetailsMutator.CouldNotApplyMutationException e) {
            throw new RyaClientException("Could not remove the user '" + username + "' from the Rya instance's details.", e);
        }
        try {
            List<String> tables = new RyaTableNames().getTableNames(instanceName, this.getConnector());
            for (String table : tables) {
                try {
                    TABLE_PERMISSIONS.revokeAllPermissions(username, table, this.getConnector());
                }
                catch (AccumuloException | AccumuloSecurityException e) {
                    throw new RyaClientException("Could not revoke access to table '" + table + "' from user '" + username + "'.", e);
                    return;
                }
            }
        }
        catch (RyaDetailsRepository.RyaDetailsRepositoryException | PrecomputedJoinStorage.PCJStorageException e) {
            throw new RyaClientException("Could not determine which tables exist for the '" + instanceName + "' instance of Rya.", e);
        }
    }
}

