/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.accumulo;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.rya.accumulo.AccumuloRdfConfiguration;
import org.apache.rya.api.client.InstanceDoesNotExistException;
import org.apache.rya.api.client.InstanceExists;
import org.apache.rya.api.client.LoadStatements;
import org.apache.rya.api.client.RyaClientException;
import org.apache.rya.api.client.accumulo.AccumuloCommand;
import org.apache.rya.api.client.accumulo.AccumuloConnectionDetails;
import org.apache.rya.api.client.accumulo.AccumuloInstanceExists;
import org.apache.rya.api.persist.RyaDAOException;
import org.apache.rya.rdftriplestore.inference.InferenceEngineException;
import org.apache.rya.sail.config.RyaSailFactory;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailException;

@DefaultAnnotation(value={NonNull.class})
public class AccumuloLoadStatements
extends AccumuloCommand
implements LoadStatements {
    private static final Logger log = Logger.getLogger(AccumuloLoadStatements.class);
    private final InstanceExists instanceExists;

    public AccumuloLoadStatements(AccumuloConnectionDetails connectionDetails, Connector connector) {
        super(connectionDetails, connector);
        this.instanceExists = new AccumuloInstanceExists(connectionDetails, connector);
    }

    public void loadStatements(String ryaInstanceName, Iterable<? extends Statement> statements) throws InstanceDoesNotExistException, RyaClientException {
        Objects.requireNonNull(ryaInstanceName);
        Objects.requireNonNull(statements);
        if (!this.instanceExists.exists(ryaInstanceName)) {
            throw new InstanceDoesNotExistException(String.format("There is no Rya instance named '%s'.", ryaInstanceName));
        }
        Sail sail = null;
        SailRepository sailRepo = null;
        SailRepositoryConnection sailRepoConn = null;
        try {
            AccumuloRdfConfiguration ryaConf = this.getAccumuloConnectionDetails().buildAccumuloRdfConfiguration(ryaInstanceName);
            ryaConf.setFlush(false);
            sail = RyaSailFactory.getInstance((Configuration)ryaConf);
            sailRepo = new SailRepository(sail);
            sailRepoConn = sailRepo.getConnection();
            sailRepoConn.add(statements, new Resource[0]);
        }
        catch (AccumuloException | AccumuloSecurityException | RyaDAOException | InferenceEngineException | SailException e) {
            log.warn((Object)"Exception while loading:", e);
            throw new RyaClientException("A problem connecting to the Rya instance named '" + ryaInstanceName + "' has caused the load to fail.", e);
        }
        catch (Exception e) {
            log.warn((Object)"Exception while loading:", (Throwable)e);
            throw new RyaClientException("A problem processing the RDF statements has caused the load into Rya instance named " + ryaInstanceName + "to fail.", (Throwable)e);
        }
        finally {
            if (sailRepoConn != null) {
                try {
                    sailRepoConn.close();
                }
                catch (RepositoryException e) {
                    log.warn((Object)"Couldn't close the SailRepoConnection that is attached to the Rya instance.", (Throwable)e);
                }
            }
            if (sailRepo != null) {
                try {
                    sailRepo.shutDown();
                }
                catch (RepositoryException e) {
                    log.warn((Object)"Couldn't shut down the SailRepository that is attached to the Rya instance.", (Throwable)e);
                }
            }
            if (sail != null) {
                try {
                    sail.shutDown();
                }
                catch (SailException e) {
                    log.warn((Object)"Couldn't shut down the Sail that is attached to the Rya instance.", (Throwable)e);
                }
            }
        }
    }
}

