/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.accumulo;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.accumulo.core.client.Connector;
import org.apache.rya.api.client.ListInstances;
import org.apache.rya.api.client.RyaClientException;
import org.apache.rya.api.client.accumulo.AccumuloCommand;
import org.apache.rya.api.client.accumulo.AccumuloConnectionDetails;

@DefaultAnnotation(value={NonNull.class})
public class AccumuloListInstances
extends AccumuloCommand
implements ListInstances {
    private final Pattern spoPattern = Pattern.compile("(.*)spo");
    private final Pattern ospPattern = Pattern.compile("(.*)osp");
    private final Pattern poPattern = Pattern.compile("(.*)po");

    public AccumuloListInstances(AccumuloConnectionDetails connectionDetails, Connector connector) {
        super(connectionDetails, connector);
    }

    public List<String> listInstances() throws RyaClientException {
        HashMap<String, InstanceTablesFound> proposedInstanceNames = new HashMap<String, InstanceTablesFound>();
        for (String table : this.getConnector().tableOperations().list()) {
            Matcher poMatcher;
            Matcher ospMatcher;
            Matcher spoMatcher = this.spoPattern.matcher(table);
            if (spoMatcher.find()) {
                String instanceName = spoMatcher.group(1);
                this.makeOrGetInstanceTables(proposedInstanceNames, instanceName).setSpoFound();
            }
            if ((ospMatcher = this.ospPattern.matcher(table)).find()) {
                String instanceName = ospMatcher.group(1);
                this.makeOrGetInstanceTables(proposedInstanceNames, instanceName).setOspFound();
            }
            if (!(poMatcher = this.poPattern.matcher(table)).find()) continue;
            String instanceName = poMatcher.group(1);
            this.makeOrGetInstanceTables(proposedInstanceNames, instanceName).setPoFound();
        }
        ArrayList<String> instanceNames = new ArrayList<String>();
        for (Map.Entry entry : proposedInstanceNames.entrySet()) {
            InstanceTablesFound tables = (InstanceTablesFound)entry.getValue();
            if (!tables.allFlagsSet()) continue;
            instanceNames.add((String)entry.getKey());
        }
        return instanceNames;
    }

    private InstanceTablesFound makeOrGetInstanceTables(Map<String, InstanceTablesFound> lookup, String instanceName) {
        if (!lookup.containsKey(instanceName)) {
            lookup.put(instanceName, new InstanceTablesFound());
        }
        return lookup.get(instanceName);
    }

    @DefaultAnnotation(value={NonNull.class})
    private static class InstanceTablesFound {
        private boolean spoFound = false;
        private boolean ospFound = false;
        private boolean poFound = false;

        private InstanceTablesFound() {
        }

        public void setSpoFound() {
            this.spoFound = true;
        }

        public void setOspFound() {
            this.ospFound = true;
        }

        public void setPoFound() {
            this.poFound = true;
        }

        public boolean allFlagsSet() {
            return this.spoFound && this.ospFound && this.poFound;
        }
    }
}

