/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.accumulo;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import org.apache.accumulo.core.client.Connector;
import org.apache.fluo.api.client.FluoClient;
import org.apache.rya.api.client.GetInstanceDetails;
import org.apache.rya.api.client.InstanceDoesNotExistException;
import org.apache.rya.api.client.ListIncrementalQueries;
import org.apache.rya.api.client.RyaClientException;
import org.apache.rya.api.client.accumulo.AccumuloCommand;
import org.apache.rya.api.client.accumulo.AccumuloConnectionDetails;
import org.apache.rya.api.client.accumulo.AccumuloGetInstanceDetails;
import org.apache.rya.api.client.accumulo.FluoClientFactory;
import org.apache.rya.api.instance.RyaDetails;
import org.apache.rya.indexing.pcj.fluo.api.ListFluoQueries;

@DefaultAnnotation(value={NonNull.class})
public class AccumuloListIncrementalQueries
extends AccumuloCommand
implements ListIncrementalQueries {
    private final GetInstanceDetails getInstanceDetails;

    public AccumuloListIncrementalQueries(AccumuloConnectionDetails connectionDetails, Connector connector) {
        super(connectionDetails, connector);
        this.getInstanceDetails = new AccumuloGetInstanceDetails(connectionDetails, connector);
    }

    public String listIncrementalQueries(String instanceName) throws RyaClientException {
        Objects.requireNonNull(instanceName);
        Optional ryaDetailsHolder = this.getInstanceDetails.getDetails(instanceName);
        boolean ryaInstanceExists = ryaDetailsHolder.isPresent();
        if (!ryaInstanceExists) {
            throw new InstanceDoesNotExistException(String.format("The '%s' instance of Rya does not exist.", instanceName));
        }
        RyaDetails.PCJIndexDetails pcjIndexDetails = ((RyaDetails)ryaDetailsHolder.get()).getPCJIndexDetails();
        boolean pcjIndexingEnabeld = pcjIndexDetails.isEnabled();
        if (!pcjIndexingEnabeld) {
            throw new RyaClientException(String.format("The '%s' instance of Rya does not have PCJ Indexing enabled.", instanceName));
        }
        Optional fluoDetailsHolder = pcjIndexDetails.getFluoDetails();
        if (fluoDetailsHolder.isPresent()) {
            String fluoAppName = ((RyaDetails.PCJIndexDetails.FluoDetails)fluoDetailsHolder.get()).getUpdateAppName();
            try {
                return this.getFluoQueryString(instanceName, fluoAppName);
            }
            catch (Exception e) {
                throw new RyaClientException("Problem while creating Fluo Query Strings.", (Throwable)e);
            }
        }
        throw new RyaClientException(String.format("The '%s' instance of Rya does not have Fluo incremental updating enabled.", instanceName));
    }

    private String getFluoQueryString(String ryaInstance, String fluoAppName) throws Exception {
        AccumuloConnectionDetails cd = super.getAccumuloConnectionDetails();
        try (FluoClient fluoClient = new FluoClientFactory().connect(cd.getUsername(), new String(cd.getUserPass()), cd.getInstanceName(), cd.getZookeepers(), fluoAppName);){
            ListFluoQueries listQueries = new ListFluoQueries();
            List queries = listQueries.listFluoQueries(fluoClient);
            String string = Joiner.on((String)"\n").join((Iterable)queries);
            return string;
        }
    }
}

