/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.accumulo;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.rya.api.client.InstanceExists;
import org.apache.rya.api.client.RyaClientException;
import org.apache.rya.api.client.accumulo.AccumuloCommand;
import org.apache.rya.api.client.accumulo.AccumuloConnectionDetails;

@DefaultAnnotation(value={NonNull.class})
public class AccumuloInstanceExists
extends AccumuloCommand
implements InstanceExists {
    public AccumuloInstanceExists(AccumuloConnectionDetails connectionDetails, Connector connector) {
        super(connectionDetails, connector);
    }

    public boolean exists(String instanceName) throws RyaClientException {
        Objects.requireNonNull(instanceName);
        TableOperations tableOps = this.getConnector().tableOperations();
        String ryaDetailsTableName = instanceName + "instance_details";
        if (tableOps.exists(ryaDetailsTableName)) {
            return true;
        }
        String spoTableName = instanceName + "spo";
        String posTableName = instanceName + "po";
        String ospTableName = instanceName + "osp";
        return tableOps.exists(spoTableName) && tableOps.exists(posTableName) && tableOps.exists(ospTableName);
    }
}

