/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.accumulo;

import com.google.common.base.Optional;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.hadoop.conf.Configuration;
import org.apache.rya.accumulo.AccumuloRdfConfiguration;
import org.apache.rya.accumulo.instance.AccumuloRyaInstanceDetailsRepository;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.client.Install;
import org.apache.rya.api.client.InstanceExists;
import org.apache.rya.api.client.RyaClientException;
import org.apache.rya.api.client.accumulo.AccumuloCommand;
import org.apache.rya.api.client.accumulo.AccumuloConnectionDetails;
import org.apache.rya.api.client.accumulo.AccumuloInstanceExists;
import org.apache.rya.api.instance.RyaDetails;
import org.apache.rya.api.instance.RyaDetailsRepository;
import org.apache.rya.api.persist.RyaDAOException;
import org.apache.rya.indexing.accumulo.ConfigUtils;
import org.apache.rya.indexing.external.PrecomputedJoinIndexerConfig;
import org.apache.rya.rdftriplestore.inference.InferenceEngineException;
import org.apache.rya.sail.config.RyaSailFactory;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailException;

@DefaultAnnotation(value={NonNull.class})
public class AccumuloInstall
extends AccumuloCommand
implements Install {
    private final InstanceExists instanceExists;

    public AccumuloInstall(AccumuloConnectionDetails connectionDetails, Connector connector) {
        super(connectionDetails, connector);
        this.instanceExists = new AccumuloInstanceExists(connectionDetails, connector);
    }

    public void install(String instanceName, Install.InstallConfiguration installConfig) throws Install.DuplicateInstanceNameException, RyaClientException {
        RyaDetails details;
        Objects.requireNonNull(instanceName);
        Objects.requireNonNull(installConfig);
        if (this.instanceExists.exists(instanceName)) {
            throw new Install.DuplicateInstanceNameException("An instance of Rya has already been installed to this Rya storage with the name '" + instanceName + "'. Try again with a different name.");
        }
        try {
            details = this.initializeRyaDetails(instanceName, installConfig, this.getConnector().whoami());
        }
        catch (RyaDetailsRepository.AlreadyInitializedException e) {
            throw new Install.DuplicateInstanceNameException("An instance of Rya has already been installed to this Rya storage with the name '" + instanceName + "'. Try again with a different name.");
        }
        catch (RyaDetailsRepository.RyaDetailsRepositoryException e) {
            throw new RyaClientException("The RyaDetails couldn't be initialized. Details: " + e.getMessage(), (Throwable)e);
        }
        AccumuloRdfConfiguration ryaConfig = AccumuloInstall.makeRyaConfig(this.getAccumuloConnectionDetails(), details);
        try {
            Sail ryaSail = RyaSailFactory.getInstance((Configuration)ryaConfig);
            ryaSail.shutDown();
        }
        catch (AccumuloException | AccumuloSecurityException | RyaDAOException | InferenceEngineException e) {
            throw new RyaClientException("Could not initialize all of the tables for the new Rya instance. This instance may be left in a bad state.", e);
        }
        catch (SailException e) {
            throw new RyaClientException("Problem shutting down the Sail object used to install Rya.", (Throwable)e);
        }
    }

    private String getVersion() {
        return "" + this.getClass().getPackage().getImplementationVersion();
    }

    private RyaDetails initializeRyaDetails(String instanceName, Install.InstallConfiguration installConfig, String installUser) throws RyaDetailsRepository.AlreadyInitializedException, RyaDetailsRepository.RyaDetailsRepositoryException {
        Objects.requireNonNull(instanceName);
        Objects.requireNonNull(installConfig);
        Objects.requireNonNull(installUser);
        AccumuloRyaInstanceDetailsRepository detailsRepo = new AccumuloRyaInstanceDetailsRepository(this.getConnector(), instanceName);
        RyaDetails.PCJIndexDetails.Builder pcjDetailsBuilder = RyaDetails.PCJIndexDetails.builder().setEnabled(Boolean.valueOf(installConfig.isPcjIndexEnabled()));
        if (installConfig.getFluoPcjAppName().isPresent()) {
            String fluoPcjAppName = (String)installConfig.getFluoPcjAppName().get();
            pcjDetailsBuilder.setFluoDetails(new RyaDetails.PCJIndexDetails.FluoDetails(fluoPcjAppName));
        }
        RyaDetails details = RyaDetails.builder().setRyaInstanceName(instanceName).setRyaVersion(this.getVersion()).addUser(installUser).setTemporalIndexDetails(new RyaDetails.TemporalIndexDetails(installConfig.isTemporalIndexEnabled())).setFreeTextDetails(new RyaDetails.FreeTextIndexDetails(installConfig.isFreeTextIndexEnabled())).setEntityCentricIndexDetails(new RyaDetails.EntityCentricIndexDetails(installConfig.isEntityCentrixIndexEnabled())).setPCJIndexDetails(pcjDetailsBuilder).setProspectorDetails(new RyaDetails.ProspectorDetails(Optional.absent())).setJoinSelectivityDetails(new RyaDetails.JoinSelectivityDetails(Optional.absent())).build();
        detailsRepo.initialize(details);
        return details;
    }

    private static AccumuloRdfConfiguration makeRyaConfig(AccumuloConnectionDetails connectionDetails, RyaDetails details) {
        AccumuloRdfConfiguration conf = new AccumuloRdfConfiguration();
        conf.setTablePrefix(details.getRyaInstanceName());
        conf.set("sc.use_freetext", "" + details.getFreeTextIndexDetails().isEnabled());
        conf.set("sc.use_temporal", "" + details.getTemporalIndexDetails().isEnabled());
        conf.set("sc.use_entity", "" + details.getEntityCentricIndexDetails().isEnabled());
        conf.set("sc.use_pcj", "" + details.getPCJIndexDetails().isEnabled());
        conf.set("rya.indexing.pcj.storageType", PrecomputedJoinIndexerConfig.PrecomputedJoinStorageType.ACCUMULO.toString());
        Optional fluoHolder = details.getPCJIndexDetails().getFluoDetails();
        PrecomputedJoinIndexerConfig.PrecomputedJoinUpdaterType updaterType = fluoHolder.isPresent() ? PrecomputedJoinIndexerConfig.PrecomputedJoinUpdaterType.FLUO : PrecomputedJoinIndexerConfig.PrecomputedJoinUpdaterType.NO_UPDATE;
        conf.set("rya.indexing.pcj.updaterType", updaterType.toString());
        conf.set("sc.cloudbase.username", connectionDetails.getUsername());
        conf.set("sc.cloudbase.password", new String(connectionDetails.getUserPass()));
        conf.set("sc.cloudbase.instancename", connectionDetails.getInstanceName());
        conf.set("sc.cloudbase.zookeepers", connectionDetails.getZookeepers());
        ConfigUtils.setIndexers((RdfCloudTripleStoreConfiguration)conf);
        return conf;
    }
}

