/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.accumulo;

import com.google.common.base.Optional;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.accumulo.core.client.Connector;
import org.apache.rya.accumulo.instance.AccumuloRyaInstanceDetailsRepository;
import org.apache.rya.api.client.GetInstanceDetails;
import org.apache.rya.api.client.InstanceDoesNotExistException;
import org.apache.rya.api.client.InstanceExists;
import org.apache.rya.api.client.RyaClientException;
import org.apache.rya.api.client.accumulo.AccumuloCommand;
import org.apache.rya.api.client.accumulo.AccumuloConnectionDetails;
import org.apache.rya.api.client.accumulo.AccumuloInstanceExists;
import org.apache.rya.api.instance.RyaDetails;
import org.apache.rya.api.instance.RyaDetailsRepository;

@DefaultAnnotation(value={NonNull.class})
public class AccumuloGetInstanceDetails
extends AccumuloCommand
implements GetInstanceDetails {
    private final InstanceExists instanceExists;

    public AccumuloGetInstanceDetails(AccumuloConnectionDetails connectionDetails, Connector connector) {
        super(connectionDetails, connector);
        this.instanceExists = new AccumuloInstanceExists(connectionDetails, connector);
    }

    public Optional<RyaDetails> getDetails(String instanceName) throws InstanceDoesNotExistException, RyaClientException {
        Objects.requireNonNull(instanceName);
        if (!this.instanceExists.exists(instanceName)) {
            throw new InstanceDoesNotExistException(String.format("There is no Rya instance named '%s'.", instanceName));
        }
        AccumuloRyaInstanceDetailsRepository detailsRepo = new AccumuloRyaInstanceDetailsRepository(this.getConnector(), instanceName);
        try {
            return Optional.of((Object)detailsRepo.getRyaInstanceDetails());
        }
        catch (RyaDetailsRepository.NotInitializedException e) {
            return Optional.absent();
        }
        catch (RyaDetailsRepository.RyaDetailsRepositoryException e) {
            throw new RyaClientException("Could not fetch the Rya instance's details.", (Throwable)e);
        }
    }
}

