/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.accumulo;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Objects;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.rya.accumulo.AccumuloRdfConfiguration;
import org.apache.rya.api.client.ExecuteSparqlQuery;
import org.apache.rya.api.client.InstanceDoesNotExistException;
import org.apache.rya.api.client.InstanceExists;
import org.apache.rya.api.client.RyaClientException;
import org.apache.rya.api.client.accumulo.AccumuloCommand;
import org.apache.rya.api.client.accumulo.AccumuloConnectionDetails;
import org.apache.rya.api.client.accumulo.AccumuloInstanceExists;
import org.apache.rya.api.persist.RyaDAOException;
import org.apache.rya.rdftriplestore.inference.InferenceEngineException;
import org.apache.rya.sail.config.RyaSailFactory;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailException;

@DefaultAnnotation(value={NonNull.class})
public class AccumuloExecuteSparqlQuery
extends AccumuloCommand
implements ExecuteSparqlQuery {
    private static final Logger log = Logger.getLogger(AccumuloExecuteSparqlQuery.class);
    private final InstanceExists instanceExists;
    private Sail sail = null;
    private SailRepository sailRepo = null;
    private SailRepositoryConnection sailRepoConn = null;

    public AccumuloExecuteSparqlQuery(AccumuloConnectionDetails connectionDetails, Connector connector) {
        super(connectionDetails, connector);
        this.instanceExists = new AccumuloInstanceExists(connectionDetails, connector);
    }

    public TupleQueryResult executeSparqlQuery(String ryaInstanceName, String sparqlQuery) throws InstanceDoesNotExistException, RyaClientException {
        Objects.requireNonNull(ryaInstanceName);
        Objects.requireNonNull(sparqlQuery);
        if (!this.instanceExists.exists(ryaInstanceName)) {
            throw new InstanceDoesNotExistException(String.format("There is no Rya instance named '%s'.", ryaInstanceName));
        }
        try {
            AccumuloRdfConfiguration ryaConf = this.getAccumuloConnectionDetails().buildAccumuloRdfConfiguration(ryaInstanceName);
            this.sail = RyaSailFactory.getInstance((Configuration)ryaConf);
            this.sailRepo = new SailRepository(this.sail);
            this.sailRepoConn = this.sailRepo.getConnection();
            TupleQuery tupleQuery = this.sailRepoConn.prepareTupleQuery(QueryLanguage.SPARQL, sparqlQuery);
            return tupleQuery.evaluate();
        }
        catch (AccumuloException | AccumuloSecurityException | RyaDAOException | InferenceEngineException | SailException e) {
            throw new RyaClientException("A problem connecting to the Rya instance named '" + ryaInstanceName + "' has caused the query to fail.", e);
        }
        catch (MalformedQueryException e) {
            throw new RyaClientException("There was a problem parsing the supplied query.", (Throwable)e);
        }
        catch (QueryEvaluationException e) {
            throw new RyaClientException("There was a problem evaluating the supplied query.", (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new RyaClientException("There was a problem executing the query against the Rya instance named " + ryaInstanceName + ".", (Throwable)e);
        }
    }

    public void close() throws IOException {
        if (this.sailRepoConn != null) {
            try {
                this.sailRepoConn.close();
            }
            catch (RepositoryException e) {
                log.warn((Object)"Couldn't close the SailRepoConnection that is attached to the Rya instance.", (Throwable)e);
            }
        }
        if (this.sailRepo != null) {
            try {
                this.sailRepo.shutDown();
            }
            catch (RepositoryException e) {
                log.warn((Object)"Couldn't shut down the SailRepository that is attached to the Rya instance.", (Throwable)e);
            }
        }
        if (this.sail != null) {
            try {
                this.sail.shutDown();
            }
            catch (SailException e) {
                log.warn((Object)"Couldn't shut down the Sail that is attached to the Rya instance.", (Throwable)e);
            }
        }
    }
}

