/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.accumulo;

import com.google.common.base.Optional;
import java.util.Objects;
import java.util.Properties;
import org.apache.accumulo.core.client.Connector;
import org.apache.fluo.api.client.FluoClient;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.rya.api.client.DeletePeriodicPCJ;
import org.apache.rya.api.client.GetInstanceDetails;
import org.apache.rya.api.client.InstanceDoesNotExistException;
import org.apache.rya.api.client.RyaClientException;
import org.apache.rya.api.client.accumulo.AccumuloCommand;
import org.apache.rya.api.client.accumulo.AccumuloConnectionDetails;
import org.apache.rya.api.client.accumulo.AccumuloDeletePCJ;
import org.apache.rya.api.client.accumulo.AccumuloGetInstanceDetails;
import org.apache.rya.api.client.accumulo.FluoClientFactory;
import org.apache.rya.api.instance.RyaDetails;
import org.apache.rya.indexing.pcj.fluo.api.DeletePeriodicQuery;
import org.apache.rya.indexing.pcj.fluo.app.query.UnsupportedQueryException;
import org.apache.rya.indexing.pcj.storage.PeriodicQueryResultStorage;
import org.apache.rya.indexing.pcj.storage.accumulo.AccumuloPeriodicQueryResultStorage;
import org.apache.rya.periodic.notification.api.PeriodicNotificationClient;
import org.apache.rya.periodic.notification.notification.CommandNotification;
import org.apache.rya.periodic.notification.registration.KafkaNotificationRegistrationClient;
import org.apache.rya.periodic.notification.serialization.CommandNotificationSerializer;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumuloDeletePeriodicPCJ
extends AccumuloCommand
implements DeletePeriodicPCJ {
    private static final Logger log = LoggerFactory.getLogger(AccumuloDeletePCJ.class);
    private final GetInstanceDetails getInstanceDetails;

    public AccumuloDeletePeriodicPCJ(AccumuloConnectionDetails connectionDetails, Connector connector) {
        super(connectionDetails, connector);
        this.getInstanceDetails = new AccumuloGetInstanceDetails(connectionDetails, connector);
    }

    public void deletePeriodicPCJ(String instanceName, String pcjId, String topic, String brokers) throws InstanceDoesNotExistException, RyaClientException {
        Objects.requireNonNull(instanceName);
        Objects.requireNonNull(pcjId);
        Optional originalDetails = this.getInstanceDetails.getDetails(instanceName);
        boolean ryaInstanceExists = originalDetails.isPresent();
        if (!ryaInstanceExists) {
            throw new InstanceDoesNotExistException(String.format("The '%s' instance of Rya does not exist.", instanceName));
        }
        boolean pcjIndexingEnabled = ((RyaDetails)originalDetails.get()).getPCJIndexDetails().isEnabled();
        if (!pcjIndexingEnabled) {
            throw new RyaClientException(String.format("The '%s' instance of Rya does not have PCJ Indexing enabled.", instanceName));
        }
        RyaDetails.PCJIndexDetails pcjIndexDetails = ((RyaDetails)originalDetails.get()).getPCJIndexDetails();
        Optional fluoDetailsHolder = pcjIndexDetails.getFluoDetails();
        if (fluoDetailsHolder.isPresent()) {
            String fluoAppName = ((RyaDetails.PCJIndexDetails.FluoDetails)pcjIndexDetails.getFluoDetails().get()).getUpdateAppName();
            try {
                this.stopUpdatingPCJ(instanceName, fluoAppName, pcjId, topic, brokers);
            }
            catch (DeletePeriodicQuery.QueryDeletionException | UnsupportedQueryException | MalformedQueryException e) {
                throw new RyaClientException(String.format("Unable to delete Periodic Query with id: %s", pcjId), e);
            }
        } else {
            log.error(String.format("Could not stop the Fluo application from updating the PCJ because the Fluo Details are missing for the Rya instance named '%s'.", instanceName));
        }
    }

    private void stopUpdatingPCJ(String ryaInstance, String fluoAppName, String pcjId, String topic, String brokers) throws UnsupportedQueryException, MalformedQueryException, DeletePeriodicQuery.QueryDeletionException {
        Objects.requireNonNull(fluoAppName);
        Objects.requireNonNull(pcjId);
        AccumuloConnectionDetails cd = super.getAccumuloConnectionDetails();
        try (FluoClient fluoClient = new FluoClientFactory().connect(cd.getUsername(), new String(cd.getUserPass()), cd.getInstanceName(), cd.getZookeepers(), fluoAppName);){
            AccumuloPeriodicQueryResultStorage periodic = new AccumuloPeriodicQueryResultStorage(this.getConnector(), ryaInstance);
            DeletePeriodicQuery deletePeriodic = new DeletePeriodicQuery(fluoClient, (PeriodicQueryResultStorage)periodic);
            deletePeriodic.deletePeriodicQuery(pcjId, AccumuloDeletePeriodicPCJ.getPeriodicNotificationClient(topic, brokers));
        }
    }

    private static PeriodicNotificationClient getPeriodicNotificationClient(String topic, String brokers) throws MalformedQueryException {
        return new KafkaNotificationRegistrationClient(topic, AccumuloDeletePeriodicPCJ.createProducer(brokers));
    }

    private static KafkaProducer<String, CommandNotification> createProducer(String brokers) {
        Properties props = new Properties();
        props.put("bootstrap.servers", brokers);
        props.put("key.serializer", StringSerializer.class.getName());
        props.put("value.serializer", CommandNotificationSerializer.class.getName());
        return new KafkaProducer(props);
    }
}

