/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.accumulo;

import com.google.common.base.Optional;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.accumulo.core.client.Connector;
import org.apache.fluo.api.client.FluoClient;
import org.apache.rya.api.client.DeletePCJ;
import org.apache.rya.api.client.GetInstanceDetails;
import org.apache.rya.api.client.InstanceDoesNotExistException;
import org.apache.rya.api.client.RyaClientException;
import org.apache.rya.api.client.accumulo.AccumuloCommand;
import org.apache.rya.api.client.accumulo.AccumuloConnectionDetails;
import org.apache.rya.api.client.accumulo.AccumuloGetInstanceDetails;
import org.apache.rya.api.client.accumulo.FluoClientFactory;
import org.apache.rya.api.instance.RyaDetails;
import org.apache.rya.indexing.pcj.fluo.api.DeleteFluoPcj;
import org.apache.rya.indexing.pcj.storage.PrecomputedJoinStorage;
import org.apache.rya.indexing.pcj.storage.accumulo.AccumuloPcjStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultAnnotation(value={NonNull.class})
public class AccumuloDeletePCJ
extends AccumuloCommand
implements DeletePCJ {
    private static final Logger log = LoggerFactory.getLogger(AccumuloDeletePCJ.class);
    private final GetInstanceDetails getInstanceDetails;

    public AccumuloDeletePCJ(AccumuloConnectionDetails connectionDetails, Connector connector) {
        super(connectionDetails, connector);
        this.getInstanceDetails = new AccumuloGetInstanceDetails(connectionDetails, connector);
    }

    public void deletePCJ(String instanceName, String pcjId) throws InstanceDoesNotExistException, RyaClientException {
        Objects.requireNonNull(instanceName);
        Objects.requireNonNull(pcjId);
        Optional originalDetails = this.getInstanceDetails.getDetails(instanceName);
        boolean ryaInstanceExists = originalDetails.isPresent();
        if (!ryaInstanceExists) {
            throw new InstanceDoesNotExistException(String.format("The '%s' instance of Rya does not exist.", instanceName));
        }
        boolean pcjIndexingEnabeld = ((RyaDetails)originalDetails.get()).getPCJIndexDetails().isEnabled();
        if (!pcjIndexingEnabeld) {
            throw new RyaClientException(String.format("The '%s' instance of Rya does not have PCJ Indexing enabled.", instanceName));
        }
        boolean pcjExists = ((RyaDetails)originalDetails.get()).getPCJIndexDetails().getPCJDetails().containsKey((Object)pcjId);
        if (!pcjExists) {
            throw new RyaClientException(String.format("The '%s' instance of Rya does not have PCJ with ID '%s'.", instanceName, pcjId));
        }
        RyaDetails.PCJIndexDetails pcjIndexDetails = ((RyaDetails)originalDetails.get()).getPCJIndexDetails();
        RyaDetails.PCJIndexDetails.PCJDetails droppedPcjDetails = (RyaDetails.PCJIndexDetails.PCJDetails)pcjIndexDetails.getPCJDetails().get((Object)pcjId);
        if (droppedPcjDetails.getUpdateStrategy().isPresent() && droppedPcjDetails.getUpdateStrategy().get() == RyaDetails.PCJIndexDetails.PCJDetails.PCJUpdateStrategy.INCREMENTAL) {
            Optional fluoDetailsHolder = pcjIndexDetails.getFluoDetails();
            if (fluoDetailsHolder.isPresent()) {
                String fluoAppName = ((RyaDetails.PCJIndexDetails.FluoDetails)pcjIndexDetails.getFluoDetails().get()).getUpdateAppName();
                this.stopUpdatingPCJ(fluoAppName, pcjId);
            } else {
                log.error(String.format("Could not stop the Fluo application from updating the PCJ because the Fluo Details are missing for the Rya instance named '%s'.", instanceName));
            }
        }
        try (AccumuloPcjStorage pcjs = new AccumuloPcjStorage(this.getConnector(), instanceName);){
            pcjs.dropPcj(pcjId);
        }
        catch (PrecomputedJoinStorage.PCJStorageException e) {
            throw new RyaClientException("Could not drop the PCJ's table from Accumulo.", (Throwable)e);
        }
    }

    private void stopUpdatingPCJ(String fluoAppName, String pcjId) {
        Objects.requireNonNull(fluoAppName);
        Objects.requireNonNull(pcjId);
        AccumuloConnectionDetails cd = super.getAccumuloConnectionDetails();
        try (FluoClient fluoClient = new FluoClientFactory().connect(cd.getUsername(), new String(cd.getUserPass()), cd.getInstanceName(), cd.getZookeepers(), fluoAppName);){
            try {
                new DeleteFluoPcj(1000).deletePcj(fluoClient, pcjId);
            }
            catch (Exception e) {
                log.warn("PcjId corresponds to an invalid PCJ. The query cannot be deleted.");
            }
        }
    }
}

