/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.accumulo;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Set;
import org.apache.accumulo.core.client.Connector;
import org.apache.fluo.api.client.FluoClient;
import org.apache.rya.accumulo.instance.AccumuloRyaInstanceDetailsRepository;
import org.apache.rya.api.client.CreatePCJ;
import org.apache.rya.api.client.GetInstanceDetails;
import org.apache.rya.api.client.InstanceDoesNotExistException;
import org.apache.rya.api.client.RyaClientException;
import org.apache.rya.api.client.accumulo.AccumuloCommand;
import org.apache.rya.api.client.accumulo.AccumuloConnectionDetails;
import org.apache.rya.api.client.accumulo.AccumuloGetInstanceDetails;
import org.apache.rya.api.client.accumulo.FluoClientFactory;
import org.apache.rya.api.instance.RyaDetails;
import org.apache.rya.api.instance.RyaDetailsRepository;
import org.apache.rya.api.instance.RyaDetailsUpdater;
import org.apache.rya.api.persist.RyaDAOException;
import org.apache.rya.indexing.pcj.fluo.api.CreateFluoPcj;
import org.apache.rya.indexing.pcj.fluo.app.query.UnsupportedQueryException;
import org.apache.rya.indexing.pcj.storage.PcjException;
import org.apache.rya.indexing.pcj.storage.PrecomputedJoinStorage;
import org.apache.rya.indexing.pcj.storage.accumulo.AccumuloPcjStorage;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.sail.SailException;

@DefaultAnnotation(value={NonNull.class})
public class AccumuloCreatePCJ
extends AccumuloCommand
implements CreatePCJ {
    private final GetInstanceDetails getInstanceDetails;

    public AccumuloCreatePCJ(AccumuloConnectionDetails connectionDetails, Connector connector) {
        super(connectionDetails, connector);
        this.getInstanceDetails = new AccumuloGetInstanceDetails(connectionDetails, connector);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String createPCJ(String instanceName, String sparql, Set<CreatePCJ.ExportStrategy> strategies) throws InstanceDoesNotExistException, RyaClientException {
        Objects.requireNonNull(instanceName);
        Objects.requireNonNull(sparql);
        Optional ryaDetailsHolder = this.getInstanceDetails.getDetails(instanceName);
        boolean ryaInstanceExists = ryaDetailsHolder.isPresent();
        if (!ryaInstanceExists) {
            throw new InstanceDoesNotExistException(String.format("The '%s' instance of Rya does not exist.", instanceName));
        }
        RyaDetails.PCJIndexDetails pcjIndexDetails = ((RyaDetails)ryaDetailsHolder.get()).getPCJIndexDetails();
        boolean pcjIndexingEnabeld = pcjIndexDetails.isEnabled();
        if (!pcjIndexingEnabeld) {
            throw new RyaClientException(String.format("The '%s' instance of Rya does not have PCJ Indexing enabled.", instanceName));
        }
        try (AccumuloPcjStorage pcjStorage = new AccumuloPcjStorage(this.getConnector(), instanceName);){
            final String pcjId = pcjStorage.createPcj(sparql);
            Optional fluoDetailsHolder = pcjIndexDetails.getFluoDetails();
            if (fluoDetailsHolder.isPresent()) {
                String fluoAppName = ((RyaDetails.PCJIndexDetails.FluoDetails)fluoDetailsHolder.get()).getUpdateAppName();
                try {
                    this.updateFluoApp(instanceName, fluoAppName, pcjId, sparql, strategies);
                }
                catch (RyaDAOException | PcjException | MalformedQueryException | QueryEvaluationException | RepositoryException | SailException e) {
                    throw new RyaClientException("Problem while initializing the Fluo application with the new PCJ.", e);
                }
                catch (UnsupportedQueryException e) {
                    throw new RyaClientException("The new PCJ could not be initialized because it either contains an unsupported query node or an invalid ExportStrategy for the given QueryType.  Projection queries can be exported to either Rya or Kafka,unless they contain an aggregation, in which case they can only be exported to Kafka.  Construct queries can be exportedto Rya and Kafka, and Periodic queries can only be exported to Rya.");
                }
                AccumuloRyaInstanceDetailsRepository detailsRepo = new AccumuloRyaInstanceDetailsRepository(this.getConnector(), instanceName);
                try {
                    new RyaDetailsUpdater((RyaDetailsRepository)detailsRepo).update(new RyaDetailsUpdater.RyaDetailsMutator(){

                        public RyaDetails mutate(RyaDetails originalDetails) throws RyaDetailsUpdater.RyaDetailsMutator.CouldNotApplyMutationException {
                            RyaDetails.PCJIndexDetails.PCJDetails originalPCJDetails = (RyaDetails.PCJIndexDetails.PCJDetails)originalDetails.getPCJIndexDetails().getPCJDetails().get((Object)pcjId);
                            RyaDetails.PCJIndexDetails.PCJDetails.Builder mutatedPCJDetails = RyaDetails.PCJIndexDetails.PCJDetails.builder((RyaDetails.PCJIndexDetails.PCJDetails)originalPCJDetails).setUpdateStrategy(RyaDetails.PCJIndexDetails.PCJDetails.PCJUpdateStrategy.INCREMENTAL);
                            RyaDetails.Builder builder = RyaDetails.builder((RyaDetails)originalDetails);
                            builder.getPCJIndexDetails().addPCJDetails(mutatedPCJDetails);
                            return builder.build();
                        }
                    });
                }
                catch (RyaDetailsRepository.RyaDetailsRepositoryException | RyaDetailsUpdater.RyaDetailsMutator.CouldNotApplyMutationException e) {
                    throw new RyaClientException("Problem while updating the Rya instance's Details to indicate the PCJ is being incrementally updated.", e);
                }
            }
            String string = pcjId;
            return string;
        }
        catch (PrecomputedJoinStorage.PCJStorageException e) {
            throw new RyaClientException("Problem while initializing the PCJ table.", (Throwable)e);
        }
    }

    public String createPCJ(String instanceName, String sparql) throws InstanceDoesNotExistException, RyaClientException {
        return this.createPCJ(instanceName, sparql, Sets.newHashSet((Object[])new CreatePCJ.ExportStrategy[]{CreatePCJ.ExportStrategy.RYA}));
    }

    private void updateFluoApp(String ryaInstance, String fluoAppName, String pcjId, String sparql, Set<CreatePCJ.ExportStrategy> strategies) throws RepositoryException, MalformedQueryException, SailException, QueryEvaluationException, PcjException, RyaDAOException, UnsupportedQueryException {
        Objects.requireNonNull(sparql);
        Objects.requireNonNull(pcjId);
        Objects.requireNonNull(strategies);
        AccumuloConnectionDetails cd = super.getAccumuloConnectionDetails();
        try (FluoClient fluoClient = new FluoClientFactory().connect(cd.getUsername(), new String(cd.getUserPass()), cd.getInstanceName(), cd.getZookeepers(), fluoAppName);){
            CreateFluoPcj fluoCreatePcj = new CreateFluoPcj();
            fluoCreatePcj.withRyaIntegration(pcjId, sparql, strategies, fluoClient, this.getConnector(), ryaInstance);
        }
    }
}

