/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.accumulo;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import net.jcip.annotations.Immutable;
import org.apache.rya.accumulo.AccumuloRdfConfiguration;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public class AccumuloConnectionDetails {
    private final String username;
    private final char[] userpass;
    private final String instanceName;
    private final String zookeepers;

    public AccumuloConnectionDetails(String username, char[] password, String instanceName, String zookeepers) {
        this.username = Objects.requireNonNull(username);
        this.userpass = Objects.requireNonNull(password);
        this.instanceName = Objects.requireNonNull(instanceName);
        this.zookeepers = Objects.requireNonNull(zookeepers);
    }

    public String getUsername() {
        return this.username;
    }

    public char[] getUserPass() {
        return this.userpass;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getZookeepers() {
        return this.zookeepers;
    }

    public AccumuloRdfConfiguration buildAccumuloRdfConfiguration(String ryaInstanceName) {
        AccumuloRdfConfiguration conf = new AccumuloRdfConfiguration();
        conf.setTablePrefix(ryaInstanceName);
        conf.setAccumuloZookeepers(this.zookeepers);
        conf.setAccumuloInstance(this.instanceName);
        conf.setAccumuloUser(this.username);
        conf.setAccumuloPassword(new String(this.userpass));
        return conf;
    }
}

