/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.accumulo;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.rya.accumulo.AccumuloRdfConfiguration;
import org.apache.rya.accumulo.instance.AccumuloRyaInstanceDetailsRepository;
import org.apache.rya.api.client.BatchUpdatePCJ;
import org.apache.rya.api.client.InstanceDoesNotExistException;
import org.apache.rya.api.client.PCJDoesNotExistException;
import org.apache.rya.api.client.RyaClientException;
import org.apache.rya.api.client.accumulo.AccumuloCommand;
import org.apache.rya.api.client.accumulo.AccumuloConnectionDetails;
import org.apache.rya.api.instance.RyaDetails;
import org.apache.rya.api.instance.RyaDetailsRepository;
import org.apache.rya.api.instance.RyaDetailsUpdater;
import org.apache.rya.api.model.VisibilityBindingSet;
import org.apache.rya.api.persist.RyaDAOException;
import org.apache.rya.indexing.pcj.storage.PcjMetadata;
import org.apache.rya.indexing.pcj.storage.PrecomputedJoinStorage;
import org.apache.rya.indexing.pcj.storage.accumulo.AccumuloPcjStorage;
import org.apache.rya.rdftriplestore.inference.InferenceEngineException;
import org.apache.rya.sail.config.RyaSailFactory;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.sparql.SPARQLParser;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;

public class AccumuloBatchUpdatePCJ
extends AccumuloCommand
implements BatchUpdatePCJ {
    private static final Logger log = Logger.getLogger(AccumuloBatchUpdatePCJ.class);

    public AccumuloBatchUpdatePCJ(AccumuloConnectionDetails connectionDetails, Connector connector) {
        super(connectionDetails, connector);
    }

    public void batchUpdate(String ryaInstanceName, String pcjId) throws InstanceDoesNotExistException, PCJDoesNotExistException, RyaClientException {
        Objects.requireNonNull(ryaInstanceName);
        Objects.requireNonNull(pcjId);
        this.verifyPCJState(ryaInstanceName, pcjId);
        this.updatePCJResults(ryaInstanceName, pcjId);
        this.updatePCJMetadata(ryaInstanceName, pcjId);
    }

    private void verifyPCJState(String ryaInstanceName, String pcjId) throws RyaClientException {
        try {
            AccumuloRyaInstanceDetailsRepository detailsRepo = new AccumuloRyaInstanceDetailsRepository(super.getConnector(), ryaInstanceName);
            RyaDetails ryaDetails = detailsRepo.getRyaInstanceDetails();
            if (!ryaDetails.getPCJIndexDetails().isEnabled()) {
                throw new RyaClientException("PCJs are not enabled for the Rya instance named '" + ryaInstanceName + "'.");
            }
            if (!ryaDetails.getPCJIndexDetails().getPCJDetails().containsKey((Object)pcjId)) {
                throw new PCJDoesNotExistException("The PCJ with id '" + pcjId + "' does not exist within Rya instance '" + ryaInstanceName + "'.");
            }
            RyaDetails.PCJIndexDetails.PCJDetails pcjDetails = (RyaDetails.PCJIndexDetails.PCJDetails)ryaDetails.getPCJIndexDetails().getPCJDetails().get((Object)pcjId);
            Optional updateStrategy = pcjDetails.getUpdateStrategy();
            if (updateStrategy.isPresent() && updateStrategy.get() == RyaDetails.PCJIndexDetails.PCJDetails.PCJUpdateStrategy.INCREMENTAL) {
                throw new RyaClientException("The PCJ with id '" + pcjId + "' is already being updated incrementally.");
            }
        }
        catch (RyaDetailsRepository.NotInitializedException e) {
            throw new InstanceDoesNotExistException("No RyaDetails are initialized for the Rya instance named '" + ryaInstanceName + "'.", (Throwable)e);
        }
        catch (RyaDetailsRepository.RyaDetailsRepositoryException e) {
            throw new RyaClientException("Could not fetch the RyaDetails for the Rya instance named '" + ryaInstanceName + "'.", (Throwable)e);
        }
    }

    private void updatePCJResults(String ryaInstanceName, String pcjId) throws InstanceDoesNotExistException, PCJDoesNotExistException, RyaClientException {
        Sail sail = null;
        SailConnection sailConn = null;
        CloseableIteration results = null;
        try (AccumuloPcjStorage pcjStorage = new AccumuloPcjStorage(super.getConnector(), ryaInstanceName);){
            sail = this.connectToRya(ryaInstanceName);
            try {
                pcjStorage.purge(pcjId);
            }
            catch (PrecomputedJoinStorage.PCJStorageException e) {
                throw new RyaClientException("Could not batch update PCJ with ID '" + pcjId + "' because the old results could not be purged from it.", (Throwable)e);
            }
            PcjMetadata metadata = pcjStorage.getPcjMetadata(pcjId);
            String sparql = metadata.getSparql();
            SPARQLParser parser = new SPARQLParser();
            ParsedQuery parsedQuery = parser.parseQuery(sparql, null);
            sailConn = sail.getConnection();
            results = sailConn.evaluate(parsedQuery.getTupleExpr(), null, null, false);
            ArrayList<VisibilityBindingSet> batch = new ArrayList<VisibilityBindingSet>(1000);
            while (results.hasNext()) {
                VisibilityBindingSet result = new VisibilityBindingSet((BindingSet)results.next(), "");
                batch.add(result);
                if (batch.size() != 1000) continue;
                pcjStorage.addResults(pcjId, batch);
                batch.clear();
            }
            if (!batch.isEmpty()) {
                pcjStorage.addResults(pcjId, batch);
                batch.clear();
            }
        }
        catch (PrecomputedJoinStorage.PCJStorageException | MalformedQueryException | QueryEvaluationException | SailException e) {
            throw new RyaClientException("Fail to batch load new results into the PCJ with ID '" + pcjId + "'.", e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (QueryEvaluationException e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (sailConn != null) {
                try {
                    sailConn.close();
                }
                catch (SailException e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (sail != null) {
                try {
                    sail.shutDown();
                }
                catch (SailException e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private Sail connectToRya(String ryaInstanceName) throws RyaClientException {
        try {
            AccumuloConnectionDetails connectionDetails = super.getAccumuloConnectionDetails();
            AccumuloRdfConfiguration ryaConf = new AccumuloRdfConfiguration();
            ryaConf.setTablePrefix(ryaInstanceName);
            ryaConf.set("sc.cloudbase.username", connectionDetails.getUsername());
            ryaConf.set("sc.cloudbase.password", new String(connectionDetails.getUserPass()));
            ryaConf.set("sc.cloudbase.zookeepers", connectionDetails.getZookeepers());
            ryaConf.set("sc.cloudbase.instancename", connectionDetails.getInstanceName());
            ryaConf.set("sc.use_pcj", "false");
            return RyaSailFactory.getInstance((Configuration)ryaConf);
        }
        catch (AccumuloException | AccumuloSecurityException | RyaDAOException | InferenceEngineException | SailException e) {
            throw new RyaClientException("Could not connect to the Rya instance named '" + ryaInstanceName + "'.", e);
        }
    }

    private void updatePCJMetadata(String ryaInstanceName, final String pcjId) throws RyaClientException {
        try {
            AccumuloRyaInstanceDetailsRepository detailsRepo = new AccumuloRyaInstanceDetailsRepository(super.getConnector(), ryaInstanceName);
            new RyaDetailsUpdater((RyaDetailsRepository)detailsRepo).update(new RyaDetailsUpdater.RyaDetailsMutator(){

                public RyaDetails mutate(RyaDetails originalDetails) throws RyaDetailsUpdater.RyaDetailsMutator.CouldNotApplyMutationException {
                    RyaDetails.PCJIndexDetails.PCJDetails originalPCJDetails = (RyaDetails.PCJIndexDetails.PCJDetails)originalDetails.getPCJIndexDetails().getPCJDetails().get((Object)pcjId);
                    RyaDetails.PCJIndexDetails.PCJDetails.Builder mutatedPCJDetails = RyaDetails.PCJIndexDetails.PCJDetails.builder((RyaDetails.PCJIndexDetails.PCJDetails)originalPCJDetails).setUpdateStrategy(RyaDetails.PCJIndexDetails.PCJDetails.PCJUpdateStrategy.BATCH).setLastUpdateTime(new Date());
                    RyaDetails.Builder builder = RyaDetails.builder((RyaDetails)originalDetails);
                    builder.getPCJIndexDetails().addPCJDetails(mutatedPCJDetails);
                    return builder.build();
                }
            });
        }
        catch (RyaDetailsRepository.RyaDetailsRepositoryException | RyaDetailsUpdater.RyaDetailsMutator.CouldNotApplyMutationException e) {
            throw new RyaClientException("Could not update the PCJ's metadata.", e);
        }
    }
}

