/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.accumulo;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.rya.accumulo.instance.AccumuloRyaInstanceDetailsRepository;
import org.apache.rya.accumulo.utils.RyaTableNames;
import org.apache.rya.accumulo.utils.TablePermissions;
import org.apache.rya.api.client.AddUser;
import org.apache.rya.api.client.InstanceDoesNotExistException;
import org.apache.rya.api.client.RyaClientException;
import org.apache.rya.api.client.accumulo.AccumuloCommand;
import org.apache.rya.api.client.accumulo.AccumuloConnectionDetails;
import org.apache.rya.api.instance.RyaDetails;
import org.apache.rya.api.instance.RyaDetailsRepository;
import org.apache.rya.api.instance.RyaDetailsUpdater;
import org.apache.rya.indexing.pcj.storage.PrecomputedJoinStorage;

@DefaultAnnotation(value={NonNull.class})
public class AccumuloAddUser
extends AccumuloCommand
implements AddUser {
    private static final TablePermissions TABLE_PERMISSIONS = new TablePermissions();

    public AccumuloAddUser(AccumuloConnectionDetails connectionDetails, Connector connector) {
        super(connectionDetails, connector);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addUser(String instanceName, String username) throws InstanceDoesNotExistException, RyaClientException {
        Objects.requireNonNull(instanceName);
        Objects.requireNonNull(username);
        try {
            RyaDetails details = new AccumuloRyaInstanceDetailsRepository(this.getConnector(), instanceName).getRyaInstanceDetails();
            ImmutableList users = details.getUsers();
            if (users.contains(username)) {
                return;
            }
        }
        catch (RyaDetailsRepository.RyaDetailsRepositoryException e) {
            throw new RyaClientException("Could not fetch the RyaDetails for Rya instance named '" + instanceName + ".", (Throwable)e);
        }
        RyaDetailsUpdater updater = new RyaDetailsUpdater((RyaDetailsRepository)new AccumuloRyaInstanceDetailsRepository(this.getConnector(), instanceName));
        try {
            updater.update(originalDetails -> RyaDetails.builder((RyaDetails)originalDetails).addUser(username).build());
        }
        catch (RyaDetailsRepository.RyaDetailsRepositoryException | RyaDetailsUpdater.RyaDetailsMutator.CouldNotApplyMutationException e) {
            throw new RyaClientException("Could not add the user '" + username + "' to the Rya instance's details.", e);
        }
        try {
            List<String> tables = new RyaTableNames().getTableNames(instanceName, this.getConnector());
            for (String table : tables) {
                try {
                    TABLE_PERMISSIONS.grantAllPermissions(username, table, this.getConnector());
                }
                catch (AccumuloException | AccumuloSecurityException e) {
                    throw new RyaClientException("Could not grant access to table '" + table + "' for user '" + username + "'.", e);
                    return;
                }
            }
        }
        catch (RyaDetailsRepository.RyaDetailsRepositoryException | PrecomputedJoinStorage.PCJStorageException e) {
            throw new RyaClientException("Could not determine which tables exist for the '" + instanceName + "' instance of Rya.", e);
        }
    }
}

