/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.rya.api.client.InstanceDoesNotExistException;
import org.apache.rya.api.client.InstanceExists;
import org.apache.rya.api.client.RyaClientException;
import org.apache.rya.api.client.SetRyaStreamsConfiguration;
import org.apache.rya.api.instance.RyaDetails;
import org.apache.rya.api.instance.RyaDetailsRepository;
import org.apache.rya.api.instance.RyaDetailsUpdater;

@DefaultAnnotation(value={NonNull.class})
public abstract class SetRyaStreamsConfigurationBase
implements SetRyaStreamsConfiguration {
    private final InstanceExists instanceExists;

    public SetRyaStreamsConfigurationBase(InstanceExists instanceExists) {
        this.instanceExists = Objects.requireNonNull(instanceExists);
    }

    protected abstract RyaDetailsRepository getRyaDetailsRepo(String var1);

    public void setRyaStreamsConfiguration(String ryaInstance, RyaDetails.RyaStreamsDetails streamsDetails) throws InstanceDoesNotExistException, RyaClientException {
        Objects.requireNonNull(ryaInstance);
        Objects.requireNonNull(streamsDetails);
        if (!this.instanceExists.exists(ryaInstance)) {
            throw new InstanceDoesNotExistException("There is no Rya instance named '" + ryaInstance + "' in this storage.");
        }
        RyaDetailsRepository repo = this.getRyaDetailsRepo(ryaInstance);
        try {
            new RyaDetailsUpdater(repo).update(oldDetails -> {
                RyaDetails.Builder builder = RyaDetails.builder((RyaDetails)oldDetails);
                builder.setRyaStreamsDetails(streamsDetails);
                return builder.build();
            });
        }
        catch (RyaDetailsRepository.RyaDetailsRepositoryException | RyaDetailsUpdater.RyaDetailsMutator.CouldNotApplyMutationException e) {
            throw new RyaClientException("Unable to update which Rya Streams subsystem is used by the '" + ryaInstance + "' Rya instance.", e);
        }
    }
}

