/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.accumulo.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.rya.accumulo.instance.AccumuloRyaInstanceDetailsRepository;
import org.apache.rya.api.instance.RyaDetails;
import org.apache.rya.api.instance.RyaDetailsRepository;
import org.apache.rya.api.layout.TablePrefixLayoutStrategy;
import org.apache.rya.indexing.accumulo.entity.EntityCentricIndex;
import org.apache.rya.indexing.accumulo.freetext.AccumuloFreeTextIndexer;
import org.apache.rya.indexing.accumulo.temporal.AccumuloTemporalIndexer;
import org.apache.rya.indexing.pcj.storage.PrecomputedJoinStorage;
import org.apache.rya.indexing.pcj.storage.accumulo.AccumuloPcjStorage;
import org.apache.rya.indexing.pcj.storage.accumulo.PcjTableNameFactory;

public class RyaTableNames {
    public List<String> getTableNames(String ryaInstanceName, Connector conn) throws RyaDetailsRepository.NotInitializedException, RyaDetailsRepository.RyaDetailsRepositoryException, PrecomputedJoinStorage.PCJStorageException {
        ArrayList<String> tables = new ArrayList<String>();
        TablePrefixLayoutStrategy coreTableNames = new TablePrefixLayoutStrategy(ryaInstanceName);
        tables.add(coreTableNames.getSpo());
        tables.add(coreTableNames.getPo());
        tables.add(coreTableNames.getOsp());
        tables.add(coreTableNames.getEval());
        tables.add(coreTableNames.getNs());
        tables.add(coreTableNames.getProspects());
        tables.add(coreTableNames.getSelectivity());
        tables.add(AccumuloRyaInstanceDetailsRepository.makeTableName((String)ryaInstanceName));
        AccumuloRyaInstanceDetailsRepository detailsRepo = new AccumuloRyaInstanceDetailsRepository(conn, ryaInstanceName);
        RyaDetails details = detailsRepo.getRyaInstanceDetails();
        if (details.getEntityCentricIndexDetails().isEnabled()) {
            tables.add(EntityCentricIndex.makeTableName(ryaInstanceName));
        }
        if (details.getFreeTextIndexDetails().isEnabled()) {
            tables.addAll(AccumuloFreeTextIndexer.makeTableNames(ryaInstanceName));
        }
        if (details.getTemporalIndexDetails().isEnabled()) {
            tables.add(AccumuloTemporalIndexer.makeTableName(ryaInstanceName));
        }
        if (details.getPCJIndexDetails().isEnabled()) {
            try (AccumuloPcjStorage pcjStorage = new AccumuloPcjStorage(conn, ryaInstanceName);){
                List pcjIds = pcjStorage.listPcjs();
                PcjTableNameFactory tableNameFactory = new PcjTableNameFactory();
                for (String pcjId : pcjIds) {
                    tables.add(tableNameFactory.makeTableName(ryaInstanceName, pcjId));
                }
            }
        }
        TableOperations tableOps = conn.tableOperations();
        Iterator tablesIt = tables.iterator();
        while (tablesIt.hasNext()) {
            String table = (String)tablesIt.next();
            if (tableOps.exists(table)) continue;
            tablesIt.remove();
        }
        return tables;
    }
}

