/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.accumulo.pcj.iterators;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBiMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.data.Key;
import org.apache.rya.api.RdfCloudTripleStoreUtils;
import org.apache.rya.api.domain.VarNameUtils;
import org.apache.rya.indexing.pcj.storage.accumulo.AccumuloPcjSerializer;
import org.apache.rya.indexing.pcj.storage.accumulo.BindingSetConverter;
import org.apache.rya.indexing.pcj.storage.accumulo.VariableOrder;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;

public class PCJKeyToJoinBindingSetIterator
implements CloseableIteration<Map.Entry<String, BindingSet>, QueryEvaluationException> {
    private Map<String, String> pcjVarMap;
    private Map<String, Value> constantConstraints;
    private int maxPrefixLen;
    private static final AccumuloPcjSerializer converter = new AccumuloPcjSerializer();
    private final Map.Entry<String, BindingSet> EMPTY_ENTRY = new RdfCloudTripleStoreUtils.CustomEntry((Object)"", (Object)new QueryBindingSet());
    private Iterator<Map.Entry<Key, org.apache.accumulo.core.data.Value>> iterator;
    private boolean hasNextCalled = false;
    private boolean isEmpty = false;
    private Map.Entry<String, BindingSet> next;
    private BatchScanner scanner;

    public PCJKeyToJoinBindingSetIterator(BatchScanner scanner, Map<String, String> pcjVarMap, Map<String, Value> constantConstraints, int maxPrefixLen) {
        Preconditions.checkNotNull((Object)scanner);
        Preconditions.checkArgument((pcjVarMap.size() > 0 ? 1 : 0) != 0, (Object)"Variable map must contain at least one variable!");
        Preconditions.checkNotNull(constantConstraints, (Object)"Constant constraints cannot be null.");
        Preconditions.checkArgument((maxPrefixLen > 0 ? 1 : 0) != 0, (Object)"Max prefix length must be greater than 0.");
        Preconditions.checkArgument((maxPrefixLen <= pcjVarMap.size() ? 1 : 0) != 0, (Object)"Max prefix length must be less than total number of binding names.");
        this.scanner = scanner;
        this.pcjVarMap = HashBiMap.create(pcjVarMap).inverse();
        this.constantConstraints = constantConstraints;
        this.maxPrefixLen = maxPrefixLen;
        this.iterator = scanner.iterator();
    }

    public PCJKeyToJoinBindingSetIterator(BatchScanner scanner, Map<String, String> pcjVarMap, int maxPrefixLen) {
        this(scanner, pcjVarMap, new HashMap<String, Value>(), maxPrefixLen);
    }

    public boolean hasNext() throws QueryEvaluationException {
        if (!this.hasNextCalled && !this.isEmpty) {
            while (this.iterator.hasNext()) {
                Key key = this.iterator.next().getKey();
                try {
                    this.next = this.getBindingSetEntryAndMatchConstants(key);
                }
                catch (BindingSetConverter.BindingSetConversionException e) {
                    throw new QueryEvaluationException("Could not deserialize PCJ BindingSet.");
                }
                if (this.next == this.EMPTY_ENTRY) continue;
                this.hasNextCalled = true;
                return true;
            }
            this.isEmpty = true;
            return false;
        }
        return !this.isEmpty;
    }

    public Map.Entry<String, BindingSet> next() throws QueryEvaluationException {
        if (this.hasNextCalled) {
            this.hasNextCalled = false;
        } else {
            if (this.isEmpty) {
                throw new NoSuchElementException();
            }
            if (this.hasNext()) {
                this.hasNextCalled = false;
            } else {
                throw new NoSuchElementException();
            }
        }
        return this.next;
    }

    public void remove() throws QueryEvaluationException {
        throw new UnsupportedOperationException();
    }

    public void close() throws QueryEvaluationException {
        this.scanner.close();
    }

    private Map.Entry<String, BindingSet> getBindingSetEntryAndMatchConstants(Key key) throws BindingSetConverter.BindingSetConversionException {
        byte[] row = key.getRow().getBytes();
        String[] varOrder = key.getColumnFamily().toString().split(";");
        BindingSet bindingSet = converter.convert(row, new VariableOrder(varOrder));
        QueryBindingSet bs = new QueryBindingSet();
        for (String var : bindingSet.getBindingNames()) {
            String mappedVar = this.pcjVarMap.get(var);
            if (VarNameUtils.isConstant((String)mappedVar) && this.constantConstraints.containsKey(mappedVar) && !this.constantConstraints.get(mappedVar).equals(bindingSet.getValue(var))) {
                return this.EMPTY_ENTRY;
            }
            bs.addBinding(mappedVar, bindingSet.getValue(var));
        }
        String orderedValueString = bindingSet.getValue(varOrder[0]).toString();
        for (int i = 1; i < this.maxPrefixLen; ++i) {
            Value value = bindingSet.getValue(varOrder[i]);
            if (value == null) continue;
            orderedValueString = orderedValueString + "\u0000" + value.toString();
        }
        return new RdfCloudTripleStoreUtils.CustomEntry((Object)orderedValueString, (Object)bs);
    }
}

