/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.accumulo.pcj.iterators;

import com.google.common.collect.HashBiMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.rya.api.domain.VarNameUtils;
import org.apache.rya.indexing.pcj.storage.accumulo.AccumuloPcjSerializer;
import org.apache.rya.indexing.pcj.storage.accumulo.BindingSetConverter;
import org.apache.rya.indexing.pcj.storage.accumulo.VariableOrder;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;

public class PCJKeyToCrossProductBindingSetIterator
implements CloseableIteration<BindingSet, QueryEvaluationException> {
    private List<BindingSet> crossProductBs;
    private Scanner scanner;
    private Iterator<Map.Entry<Key, org.apache.accumulo.core.data.Value>> iterator;
    private Map<String, String> pcjVarMap;
    private Set<String> unAssuredVariables;
    private final AccumuloPcjSerializer converter = new AccumuloPcjSerializer();
    private final BindingSet EMPTY_BINDINGSET = new QueryBindingSet();
    private Iterator<BindingSet> crossProductIter = Collections.emptyIterator();
    private Map<String, Value> constantConstraints;
    private BindingSet next;
    private boolean hasNextCalled = false;
    private boolean isEmpty = false;
    private boolean crossProductBsExist = false;
    private boolean constantConstraintsExist = false;

    public PCJKeyToCrossProductBindingSetIterator(Scanner scanner, List<BindingSet> crossProductBs, Map<String, Value> constantConstraints, Set<String> unAssuredVariables, Map<String, String> pcjVarMap) {
        this.crossProductBs = crossProductBs;
        this.scanner = scanner;
        this.iterator = scanner.iterator();
        this.pcjVarMap = HashBiMap.create(pcjVarMap).inverse();
        this.constantConstraints = constantConstraints;
        this.crossProductBsExist = crossProductBs.size() > 0;
        this.constantConstraintsExist = constantConstraints.size() > 0;
        this.unAssuredVariables = unAssuredVariables;
    }

    public boolean hasNext() throws QueryEvaluationException {
        if (!this.hasNextCalled && !this.isEmpty) {
            if (this.crossProductBsExist) {
                while (this.crossProductIter.hasNext() || this.iterator.hasNext()) {
                    if (!this.crossProductIter.hasNext()) {
                        Key key = this.iterator.next().getKey();
                        try {
                            this.crossProductIter = this.getCrossProducts(this.getBindingSet(key));
                        }
                        catch (BindingSetConverter.BindingSetConversionException e) {
                            throw new QueryEvaluationException((Throwable)e);
                        }
                    }
                    if (!this.crossProductIter.hasNext()) continue;
                    this.next = this.crossProductIter.next();
                    this.hasNextCalled = true;
                    return true;
                }
            } else {
                while (this.iterator.hasNext()) {
                    Key key = this.iterator.next().getKey();
                    try {
                        this.next = this.getBindingSet(key);
                    }
                    catch (BindingSetConverter.BindingSetConversionException e) {
                        throw new QueryEvaluationException((Throwable)e);
                    }
                    if (this.next == null || this.next == this.EMPTY_BINDINGSET) continue;
                    this.hasNextCalled = true;
                    return true;
                }
            }
            this.isEmpty = true;
            return false;
        }
        return !this.isEmpty;
    }

    public BindingSet next() throws QueryEvaluationException {
        if (this.hasNextCalled) {
            this.hasNextCalled = false;
        } else {
            if (this.isEmpty) {
                throw new NoSuchElementException();
            }
            if (this.hasNext()) {
                this.hasNextCalled = false;
            } else {
                throw new NoSuchElementException();
            }
        }
        return this.next;
    }

    public void remove() throws QueryEvaluationException {
        throw new UnsupportedOperationException();
    }

    public void close() throws QueryEvaluationException {
        this.scanner.close();
    }

    private BindingSet getBindingSet(Key key) throws BindingSetConverter.BindingSetConversionException, QueryEvaluationException {
        byte[] row = key.getRow().getBytes();
        String[] varOrder = key.getColumnFamily().toString().split(";");
        BindingSet bindingSet = this.converter.convert(row, new VariableOrder(varOrder));
        QueryBindingSet bs = new QueryBindingSet();
        for (String var : bindingSet.getBindingNames()) {
            String mappedVar = null;
            if (!this.pcjVarMap.containsKey(var)) {
                throw new QueryEvaluationException("PCJ Variable has no mapping to query variable.");
            }
            mappedVar = this.pcjVarMap.get(var);
            if (this.constantConstraintsExist && VarNameUtils.isConstant((String)mappedVar) && this.constantConstraints.containsKey(mappedVar) && !this.constantConstraints.get(mappedVar).equals(bindingSet.getValue(var))) {
                return this.EMPTY_BINDINGSET;
            }
            if (VarNameUtils.isConstant((String)mappedVar)) continue;
            bs.addBinding(mappedVar, bindingSet.getValue(var));
        }
        return bs;
    }

    private Iterator<BindingSet> getCrossProducts(BindingSet bs) {
        HashSet<BindingSet> crossProducts = new HashSet<BindingSet>();
        for (BindingSet bSet : this.crossProductBs) {
            BindingSet prod = this.takeCrossProduct(bSet, bs);
            if (prod == this.EMPTY_BINDINGSET) continue;
            crossProducts.add(prod);
        }
        return crossProducts.iterator();
    }

    private BindingSet takeCrossProduct(BindingSet leftBs, BindingSet rightBs) {
        if (this.bindingSetsIntersect(leftBs, rightBs)) {
            return this.EMPTY_BINDINGSET;
        }
        QueryBindingSet bs = new QueryBindingSet(leftBs);
        for (String s : rightBs.getBindingNames()) {
            if (bs.getValue(s) != null) continue;
            bs.addBinding(s, rightBs.getValue(s));
        }
        return bs;
    }

    private boolean bindingSetsIntersect(BindingSet bs1, BindingSet bs2) {
        for (String s : bs1.getBindingNames()) {
            if (bs2.getValue(s) == null || this.unAssuredVariables.contains(s)) continue;
            return true;
        }
        return false;
    }
}

