/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.accumulo.pcj.iterators;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;

public class IteratorCombiner
implements CloseableIteration<BindingSet, QueryEvaluationException> {
    private Collection<CloseableIteration<BindingSet, QueryEvaluationException>> iterators;
    private Iterator<CloseableIteration<BindingSet, QueryEvaluationException>> iteratorIterator;
    private CloseableIteration<BindingSet, QueryEvaluationException> currIter;
    private boolean isEmpty = false;
    private boolean hasNextCalled = false;
    private BindingSet next;

    public IteratorCombiner(Collection<CloseableIteration<BindingSet, QueryEvaluationException>> iterators) {
        Preconditions.checkArgument((iterators.size() > 0 ? 1 : 0) != 0);
        this.iterators = iterators;
        this.iteratorIterator = iterators.iterator();
        this.currIter = this.iteratorIterator.next();
    }

    public boolean hasNext() throws QueryEvaluationException {
        if (!this.hasNextCalled && !this.isEmpty) {
            while (this.currIter.hasNext() || this.iteratorIterator.hasNext()) {
                if (!this.currIter.hasNext()) {
                    this.currIter = this.iteratorIterator.next();
                }
                if (!this.currIter.hasNext()) continue;
                this.next = (BindingSet)this.currIter.next();
                this.hasNextCalled = true;
                return true;
            }
            this.isEmpty = true;
            return false;
        }
        return !this.isEmpty;
    }

    public BindingSet next() throws QueryEvaluationException {
        if (this.hasNextCalled) {
            this.hasNextCalled = false;
        } else {
            if (this.isEmpty) {
                throw new NoSuchElementException();
            }
            if (this.hasNext()) {
                this.hasNextCalled = false;
            } else {
                throw new NoSuchElementException();
            }
        }
        return this.next;
    }

    public void remove() throws QueryEvaluationException {
        throw new UnsupportedOperationException();
    }

    public void close() throws QueryEvaluationException {
        for (CloseableIteration<BindingSet, QueryEvaluationException> iterator : this.iterators) {
            iterator.close();
        }
    }
}

