/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.accumulo.pcj.iterators;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.rya.api.domain.VarNameUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;

public class BindingSetHashJoinIterator
implements CloseableIteration<BindingSet, QueryEvaluationException> {
    private Multimap<String, BindingSet> bindingJoinVarHash;
    private CloseableIteration<Map.Entry<String, BindingSet>, QueryEvaluationException> joinIter;
    private Iterator<BindingSet> joinedBindingSets = Collections.emptyIterator();
    private Set<String> unAssuredVariables;
    private HashJoinType type;
    private final BindingSet EMPTY_BINDINGSET = new QueryBindingSet();
    private BindingSet next;
    private boolean hasNextCalled = false;
    private boolean isEmpty = false;

    public BindingSetHashJoinIterator(Multimap<String, BindingSet> bindingJoinVarHash, CloseableIteration<Map.Entry<String, BindingSet>, QueryEvaluationException> joinIter, Set<String> unAssuredVariables, HashJoinType type) {
        this.bindingJoinVarHash = bindingJoinVarHash;
        this.joinIter = joinIter;
        this.type = type;
        this.unAssuredVariables = unAssuredVariables;
    }

    public boolean hasNext() throws QueryEvaluationException {
        if (!this.hasNextCalled && !this.isEmpty) {
            while (this.joinedBindingSets.hasNext() || this.joinIter.hasNext()) {
                if (!this.joinedBindingSets.hasNext()) {
                    Map.Entry entry = (Map.Entry)this.joinIter.next();
                    this.joinedBindingSets = this.joinBindingSetEntry(entry);
                }
                if (!this.joinedBindingSets.hasNext()) continue;
                this.next = this.joinedBindingSets.next();
                this.hasNextCalled = true;
                return true;
            }
            this.isEmpty = true;
            return false;
        }
        return !this.isEmpty;
    }

    public BindingSet next() throws QueryEvaluationException {
        if (this.hasNextCalled) {
            this.hasNextCalled = false;
        } else {
            if (this.isEmpty) {
                throw new NoSuchElementException();
            }
            if (this.hasNext()) {
                this.hasNextCalled = false;
            } else {
                throw new NoSuchElementException();
            }
        }
        return this.next;
    }

    public void remove() throws QueryEvaluationException {
        throw new UnsupportedOperationException();
    }

    public void close() throws QueryEvaluationException {
        this.joinIter.close();
    }

    private List<String> getValueOrders(String valOrderString) {
        ArrayList<String> valueOrders = new ArrayList<String>();
        String[] splitValOrderString = valOrderString.split("\u0000");
        StringBuffer buffer = new StringBuffer();
        buffer.append(splitValOrderString[0]);
        valueOrders.add(buffer.substring(0));
        for (int i = 1; i < splitValOrderString.length; ++i) {
            buffer.append("\u0000" + splitValOrderString[i]);
            valueOrders.add(buffer.substring(0));
        }
        return valueOrders;
    }

    private BindingSet joinBindingSets(BindingSet leftBs, BindingSet rightBs) {
        Sets.SetView commonVars = Sets.intersection((Set)leftBs.getBindingNames(), (Set)rightBs.getBindingNames());
        for (String s : commonVars) {
            if (leftBs.getValue(s).equals(rightBs.getValue(s)) || this.unAssuredVariables.contains(s)) continue;
            return this.EMPTY_BINDINGSET;
        }
        QueryBindingSet bs = new QueryBindingSet(this.removeConstants(leftBs));
        rightBs = this.removeConstants(rightBs);
        for (String s : rightBs.getBindingNames()) {
            if (bs.getValue(s) != null) continue;
            bs.addBinding(s, rightBs.getValue(s));
        }
        return bs;
    }

    private BindingSet removeConstants(BindingSet bs) {
        QueryBindingSet bSet = new QueryBindingSet();
        for (String s : bs.getBindingNames()) {
            if (VarNameUtils.isConstant((String)s)) continue;
            bSet.addBinding(bs.getBinding(s));
        }
        return bSet;
    }

    private Iterator<BindingSet> joinBindingSetEntry(Map.Entry<String, BindingSet> entry) {
        ArrayList<Collection<BindingSet>> matches = new ArrayList<Collection<BindingSet>>();
        if (this.type == HashJoinType.CONSTANT_JOIN_VAR) {
            if (this.bindingJoinVarHash.containsKey((Object)entry.getKey())) {
                matches.add(this.bindingJoinVarHash.get((Object)entry.getKey()));
            }
        } else {
            List<String> valOrders = this.getValueOrders(entry.getKey());
            for (String s : valOrders) {
                if (!this.bindingJoinVarHash.containsKey((Object)s)) continue;
                matches.add(this.bindingJoinVarHash.get((Object)s));
            }
        }
        if (matches.size() == 0) {
            return Collections.emptyIterator();
        }
        return new BindingSetCollectionsJoinIterator(entry.getValue(), matches);
    }

    private class BindingSetCollectionsJoinIterator
    implements Iterator<BindingSet> {
        private Iterator<Collection<BindingSet>> collectionIter;
        private Iterator<BindingSet> bsIter = Collections.emptyIterator();
        private BindingSet next;
        private BindingSet joinBs;
        private boolean hasNextCalled = false;
        private boolean isEmpty = false;

        public BindingSetCollectionsJoinIterator(BindingSet bs, List<Collection<BindingSet>> collection) {
            this.collectionIter = collection.iterator();
            this.joinBs = bs;
        }

        @Override
        public boolean hasNext() {
            if (!this.hasNextCalled && !this.isEmpty) {
                while (this.bsIter.hasNext() || this.collectionIter.hasNext()) {
                    if (!this.bsIter.hasNext()) {
                        this.bsIter = this.collectionIter.next().iterator();
                    }
                    this.next = BindingSetHashJoinIterator.this.joinBindingSets(this.bsIter.next(), this.joinBs);
                    if (this.next == BindingSetHashJoinIterator.this.EMPTY_BINDINGSET) continue;
                    this.hasNextCalled = true;
                    return true;
                }
                this.isEmpty = true;
                return false;
            }
            return !this.isEmpty;
        }

        @Override
        public BindingSet next() {
            if (this.hasNextCalled) {
                this.hasNextCalled = false;
            } else {
                if (this.isEmpty) {
                    throw new NoSuchElementException();
                }
                if (this.hasNext()) {
                    this.hasNextCalled = false;
                } else {
                    throw new NoSuchElementException();
                }
            }
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static enum HashJoinType {
        CONSTANT_JOIN_VAR,
        VARIABLE_JOIN_VAR;

    }
}

