/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.accumulo.documentIndex;

import org.apache.hadoop.io.Text;

public class TextColumn {
    private Text columnFamily;
    private Text columnQualifier;
    private boolean isPrefix = false;

    public TextColumn(Text columnFamily, Text columnQualifier) {
        this.columnFamily = columnFamily;
        this.columnQualifier = columnQualifier;
    }

    public TextColumn(TextColumn other) {
        this.columnFamily = new Text(other.columnFamily);
        this.columnQualifier = new Text(other.columnQualifier);
        this.isPrefix = other.isPrefix;
    }

    public Text getColumnFamily() {
        return this.columnFamily;
    }

    public boolean isPrefix() {
        return this.isPrefix;
    }

    public void setIsPrefix(boolean isPrefix) {
        this.isPrefix = isPrefix;
    }

    public boolean isValid() {
        return this.columnFamily != null && this.columnQualifier != null;
    }

    public Text getColumnQualifier() {
        return this.columnQualifier;
    }

    public void setColumnFamily(Text cf) {
        this.columnFamily = cf;
    }

    public void setColumnQualifier(Text cq) {
        this.columnQualifier = cq;
    }

    public String toString() {
        return this.columnFamily.toString() + ",  " + this.columnQualifier.toString() + ",    prefix:" + this.isPrefix;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof TextColumn)) {
            return false;
        }
        TextColumn tc = (TextColumn)other;
        return this.columnFamily.equals((Object)tc.columnFamily) && this.columnQualifier.equals((Object)tc.columnQualifier) && this.isPrefix == tc.isPrefix;
    }
}

