/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.accumulo.documentIndex;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;
import org.apache.rya.accumulo.documentIndex.TextColumn;

public class DocumentIndexIntersectingIterator
implements SortedKeyValueIterator<Key, Value> {
    protected Text nullText = new Text();
    protected static final Logger log = Logger.getLogger(DocumentIndexIntersectingIterator.class);
    TermSource[] sources;
    int sourcesCount = 0;
    Range overallRange;
    protected Text currentRow = null;
    protected Text currentTermCond = new Text(emptyByteArray);
    static final byte[] emptyByteArray = new byte[0];
    protected Key topKey = null;
    protected Value value = new Value(emptyByteArray);
    protected String ctxt = null;
    protected boolean hasContext = false;
    protected boolean termCondSet = false;
    private static final String columnOptionName = "columns";
    private static final String columnPrefix = "prefixes";
    private static final String context = "context";

    protected Text getRow(Key key) {
        return key.getRow();
    }

    protected Text getTerm(Key key) {
        return key.getColumnFamily();
    }

    protected Text getTermCond(Key key) {
        return key.getColumnQualifier();
    }

    protected Key buildKey(Text row, TextColumn column) {
        return new Key(row, column.getColumnFamily() == null ? this.nullText : column.getColumnFamily(), column.getColumnQualifier());
    }

    protected Key buildKey(Text row, Text term) {
        return new Key(row, term == null ? this.nullText : term);
    }

    protected Key buildKey(Text row, Text term, Text termCond) {
        return new Key(row, term == null ? this.nullText : term, termCond);
    }

    protected Key buildFollowRowKey(Key key, Text term, Text termCond) {
        return new Key(this.getRow(key.followingKey(PartialKey.ROW)), term == null ? this.nullText : term, termCond);
    }

    public DocumentIndexIntersectingIterator() {
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return new DocumentIndexIntersectingIterator(this, env);
    }

    private DocumentIndexIntersectingIterator(DocumentIndexIntersectingIterator other, IteratorEnvironment env) {
        if (other.sources != null) {
            this.sourcesCount = other.sourcesCount;
            this.sources = new TermSource[this.sourcesCount];
            for (int i = 0; i < this.sourcesCount; ++i) {
                this.sources[i] = new TermSource((SortedKeyValueIterator<Key, Value>)other.sources[i].iter.deepCopy(env), other.sources[i].column);
            }
        }
    }

    public Key getTopKey() {
        return this.topKey;
    }

    public Value getTopValue() {
        return this.value;
    }

    public boolean hasTop() {
        return this.currentRow != null;
    }

    private boolean seekOneSource(int sourceID) throws IOException {
        boolean advancedCursor;
        block11: {
            String[] cq;
            block13: {
                block12: {
                    advancedCursor = false;
                    while (true) {
                        Key seekKey;
                        int termCompare;
                        int rowCompare;
                        if (!this.sources[sourceID].hasTop()) {
                            this.currentRow = null;
                            return true;
                        }
                        int endCompare = -1;
                        if (this.overallRange.getEndKey() != null) {
                            endCompare = this.overallRange.getEndKey().getRow().compareTo((BinaryComparable)this.sources[sourceID].top.getRow());
                            if (!this.overallRange.isEndKeyInclusive() && endCompare <= 0 || endCompare < 0) {
                                this.currentRow = null;
                                return true;
                            }
                        }
                        if ((rowCompare = this.currentRow.compareTo((BinaryComparable)this.getRow(this.sources[sourceID].top))) > 0) {
                            Key seekKey2 = this.buildKey(this.currentRow, this.sources[sourceID].term);
                            this.sources[sourceID].seek(new Range(seekKey2, true, null, false));
                            continue;
                        }
                        if (rowCompare < 0) {
                            this.currentRow.set(this.getRow(this.sources[sourceID].top));
                            advancedCursor = true;
                            continue;
                        }
                        if (!this.sources[sourceID].column.isValid()) break;
                        boolean isPrefix = false;
                        boolean contextEqual = false;
                        String tempContext = "";
                        String[] cQ = this.getTermCond(this.sources[sourceID].top).toString().split("\u0000");
                        tempContext = cQ[0];
                        if (!this.hasContext && this.ctxt == null) {
                            this.ctxt = cQ[0];
                        }
                        contextEqual = this.ctxt.equals(cQ[0]);
                        String s1 = this.sources[sourceID].termCond.toString();
                        String s2 = cQ[1] + "\u0000" + cQ[2];
                        isPrefix = this.sources[sourceID].isPrefix ? s2.startsWith(s1 + "\u0000") : s2.startsWith(s1);
                        int n = termCompare = contextEqual && isPrefix ? 0 : (this.ctxt + "\u0000" + s1).compareTo(cQ[0] + "\u0000" + s2);
                        if (termCompare > 0) {
                            seekKey = this.buildKey(this.currentRow, this.sources[sourceID].term, new Text(this.ctxt + "\u0000" + this.sources[sourceID].termCond.toString()));
                            this.sources[sourceID].seek(new Range(seekKey, true, null, false));
                            continue;
                        }
                        if (termCompare >= 0) break;
                        if (endCompare == 0) {
                            this.currentRow = null;
                            return true;
                        }
                        if (this.hasContext || tempContext.length() == 0) {
                            seekKey = this.buildFollowRowKey(this.sources[sourceID].top, this.sources[sourceID].term, new Text(this.ctxt + "\u0000" + this.sources[sourceID].termCond.toString()));
                            this.sources[sourceID].seek(new Range(seekKey, true, null, false));
                            continue;
                        }
                        if (contextEqual && !isPrefix) {
                            seekKey = this.buildKey(this.currentRow, this.sources[sourceID].term, new Text(this.ctxt + "\u0001"));
                            this.sources[sourceID].seek(new Range(seekKey, true, null, false));
                            if (this.sources[sourceID].top == null) continue;
                            this.ctxt = this.getTermCond(this.sources[sourceID].top).toString().split("\u0000")[0];
                            continue;
                        }
                        seekKey = this.buildKey(this.currentRow, this.sources[sourceID].term, new Text(tempContext + "\u0000" + this.sources[sourceID].termCond.toString()));
                        this.sources[sourceID].seek(new Range(seekKey, true, null, false));
                        if (this.sources[sourceID].top == null) continue;
                        this.ctxt = this.getTermCond(this.sources[sourceID].top).toString().split("\u0000")[0];
                    }
                    this.sources[sourceID].currentCQ.set(this.getTermCond(this.sources[sourceID].top));
                    if (this.sources[sourceID].next == null) break block11;
                    if (this.termCondSet || !this.hasContext) break block12;
                    if (!this.sources[sourceID].next.getRow().equals((Object)this.currentRow) || !this.sources[sourceID].next.getColumnQualifier().toString().startsWith(this.ctxt + "\u0000" + this.sources[sourceID].termCond.toString())) break block11;
                    this.currentTermCond.set(new Text(Integer.toString(sourceID)));
                    this.termCondSet = true;
                    break block11;
                }
                if (this.termCondSet) break block11;
                cq = this.getTermCond(this.sources[sourceID].next).toString().split("\u0000");
                if (!this.sources[sourceID].next.getRow().equals((Object)this.currentRow)) break block11;
                if (!this.sources[sourceID].next.getColumnQualifier().toString().startsWith(this.ctxt + "\u0000" + this.sources[sourceID].termCond.toString())) break block13;
                this.currentTermCond.set(new Text(Integer.toString(sourceID)));
                this.termCondSet = true;
                break block11;
            }
            if (!(cq[1] + "\u0000" + cq[2]).startsWith(this.sources[sourceID].termCond.toString())) break block11;
            this.currentTermCond.set(new Text(Integer.toString(sourceID)));
        }
        return advancedCursor;
    }

    public void next() throws IOException {
        if (this.currentRow == null) {
            return;
        }
        if (this.currentTermCond.getLength() != 0) {
            int id = Integer.parseInt(this.currentTermCond.toString());
            this.sources[id].next();
            this.currentTermCond.set(emptyByteArray);
            this.termCondSet = false;
            if (this.sources[id].top != null && !this.hasContext) {
                this.ctxt = this.getTermCond(this.sources[id].top).toString().split("\u0000")[0];
            }
            this.advanceToIntersection();
            return;
        }
        this.sources[0].next();
        if (this.sources[0].top != null && !this.hasContext) {
            this.ctxt = this.getTermCond(this.sources[0].top).toString().split("\u0000")[0];
        }
        this.advanceToIntersection();
    }

    protected void advanceToIntersection() throws IOException {
        boolean cursorChanged = true;
        block0: while (cursorChanged) {
            cursorChanged = false;
            for (int i = 0; i < this.sourcesCount; ++i) {
                if (this.currentRow == null) {
                    this.topKey = null;
                    return;
                }
                if (!this.seekOneSource(i)) continue;
                this.currentTermCond.set(emptyByteArray);
                this.termCondSet = false;
                cursorChanged = true;
                continue block0;
            }
        }
        String cq = "";
        for (int i = 0; i < this.sourcesCount; ++i) {
            cq = cq + this.sources[i].currentCQ.toString() + "\u001d\u001e";
        }
        this.topKey = this.currentTermCond.getLength() == 0 ? this.buildKey(this.currentRow, this.nullText, new Text(cq + -1)) : this.buildKey(this.currentRow, this.nullText, new Text(cq + this.currentTermCond.toString()));
    }

    public static String stringTopKey(SortedKeyValueIterator<Key, Value> iter) {
        if (iter.hasTop()) {
            return ((Key)iter.getTopKey()).toString();
        }
        return "";
    }

    protected static String encodeColumns(TextColumn[] columns) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            sb.append(new String(Base64.encodeBase64((byte[])TextUtil.getBytes((Text)columns[i].getColumnFamily())), StandardCharsets.UTF_8));
            sb.append('\n');
            sb.append(new String(Base64.encodeBase64((byte[])TextUtil.getBytes((Text)columns[i].getColumnQualifier())), StandardCharsets.UTF_8));
            sb.append('\u0001');
        }
        return sb.toString();
    }

    protected static TextColumn[] decodeColumns(String columns) {
        String[] columnStrings = columns.split("\u0001");
        TextColumn[] columnTexts = new TextColumn[columnStrings.length];
        for (int i = 0; i < columnStrings.length; ++i) {
            String[] columnComponents = columnStrings[i].split("\n");
            columnTexts[i] = new TextColumn(new Text(Base64.decodeBase64((byte[])columnComponents[0].getBytes(StandardCharsets.UTF_8))), new Text(Base64.decodeBase64((byte[])columnComponents[1].getBytes(StandardCharsets.UTF_8))));
        }
        return columnTexts;
    }

    protected static String encodeContext(String context) {
        return new String(Base64.encodeBase64((byte[])context.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    protected static String decodeContext(String context) {
        if (context == null) {
            return null;
        }
        return new String(Base64.decodeBase64((byte[])context.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    protected static String encodeBooleans(boolean[] prefixes) {
        byte[] bytes = new byte[prefixes.length];
        for (int i = 0; i < prefixes.length; ++i) {
            bytes[i] = prefixes[i] ? (byte)1 : 0;
        }
        return new String(Base64.encodeBase64((byte[])bytes), StandardCharsets.UTF_8);
    }

    protected static boolean[] decodeBooleans(String prefixes) {
        if (prefixes == null) {
            return null;
        }
        byte[] bytes = Base64.decodeBase64((byte[])prefixes.getBytes(StandardCharsets.UTF_8));
        boolean[] bFlags = new boolean[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            bFlags[i] = bytes[i] == 1;
        }
        return bFlags;
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        TextColumn[] terms = DocumentIndexIntersectingIterator.decodeColumns(options.get(columnOptionName));
        boolean[] prefixes = DocumentIndexIntersectingIterator.decodeBooleans(options.get(columnPrefix));
        this.ctxt = DocumentIndexIntersectingIterator.decodeContext(options.get(context));
        if (this.ctxt != null) {
            this.hasContext = true;
        }
        if (terms.length < 2) {
            throw new IllegalArgumentException("IntersectionIterator requires two or more columns families");
        }
        this.sources = new TermSource[terms.length];
        this.sources[0] = new TermSource(source, terms[0]);
        for (int i = 1; i < terms.length; ++i) {
            this.sources[i] = new TermSource((SortedKeyValueIterator<Key, Value>)source.deepCopy(env), terms[i]);
            this.sources[i].isPrefix = prefixes[i];
        }
        this.sourcesCount = terms.length;
    }

    public void seek(Range range, Collection<ByteSequence> seekColumnFamilies, boolean inclusive) throws IOException {
        this.overallRange = new Range(range);
        this.currentRow = new Text();
        this.currentTermCond.set(emptyByteArray);
        this.termCondSet = false;
        if (this.rangeCqValid(range)) {
            String[] cqInfo = this.cqParser(range.getStartKey().getColumnQualifier());
            int id = Integer.parseInt(cqInfo[1]);
            if (id >= 0) {
                for (int i = 0; i < this.sourcesCount; ++i) {
                    Key sourceKey;
                    if (i == id) {
                        sourceKey = this.buildKey(this.getRow(range.getStartKey()), this.sources[i].term, new Text(cqInfo[0]));
                        this.sources[i].seek(new Range(sourceKey, true, null, false));
                        this.sources[i].next();
                        if (this.hasContext || !this.sources[i].hasTop()) continue;
                        this.ctxt = this.getTermCond(this.sources[i].top).toString().split("\u0000")[0];
                        continue;
                    }
                    sourceKey = this.buildKey(this.getRow(range.getStartKey()), this.sources[i].term);
                    this.sources[i].seek(new Range(sourceKey, true, null, false));
                }
            } else {
                for (int i = 0; i < this.sourcesCount; ++i) {
                    Key sourceKey = this.buildKey(this.getRow(range.getStartKey()), this.sources[i].term, range.getStartKey().getColumnQualifier());
                    this.sources[i].seek(new Range(sourceKey, true, null, false));
                }
            }
        } else {
            for (int i = 0; i < this.sourcesCount; ++i) {
                if (range.getStartKey() != null) {
                    Key sourceKey = this.buildKey(this.getRow(range.getStartKey()), this.sources[i].term);
                    this.sources[i].seek(new Range(sourceKey, true, null, false));
                    continue;
                }
                this.sources[i].seek(range);
            }
        }
        this.advanceToIntersection();
    }

    private String[] cqParser(Text cq) {
        String cQ = cq.toString();
        String[] cqComponents = cQ.split("\u001d\u001e");
        int id = -1;
        String[] valPos = new String[2];
        if (cqComponents.length > 1) {
            id = Integer.parseInt(cqComponents[cqComponents.length - 1]);
            if (id >= 0) {
                valPos[0] = cqComponents[id].toString();
                valPos[1] = "" + id;
            } else {
                valPos[0] = cqComponents[0].toString();
                valPos[1] = "" + id;
            }
        } else {
            valPos[0] = cq.toString();
            valPos[1] = "-1";
        }
        return valPos;
    }

    private boolean rangeCqValid(Range range) {
        return range.getStartKey() != null && range.getStartKey().getColumnQualifier() != null;
    }

    public void addSource(SortedKeyValueIterator<Key, Value> source, IteratorEnvironment env, TextColumn column) {
        if (this.sources == null) {
            this.sources = new TermSource[1];
        } else {
            TermSource[] localSources = new TermSource[this.sources.length + 1];
            int currSource = 0;
            for (TermSource myTerm : this.sources) {
                localSources[currSource] = new TermSource(myTerm);
                ++currSource;
            }
            this.sources = localSources;
        }
        this.sources[this.sourcesCount] = new TermSource((SortedKeyValueIterator<Key, Value>)source.deepCopy(env), column);
        ++this.sourcesCount;
    }

    public static void setColumnFamilies(IteratorSetting cfg, TextColumn[] columns) {
        if (columns.length < 2) {
            throw new IllegalArgumentException("Must supply at least two terms to intersect");
        }
        boolean[] prefix = new boolean[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            prefix[i] = columns[i].isPrefix();
        }
        cfg.addOption(columnPrefix, DocumentIndexIntersectingIterator.encodeBooleans(prefix));
        cfg.addOption(columnOptionName, DocumentIndexIntersectingIterator.encodeColumns(columns));
    }

    public static void setContext(IteratorSetting cfg, String context) {
        cfg.addOption(context, DocumentIndexIntersectingIterator.encodeContext(context));
    }

    public static class TermSource {
        public SortedKeyValueIterator<Key, Value> iter;
        public Text term;
        public Text termCond;
        public Collection<ByteSequence> seekColfams;
        public TextColumn column;
        public boolean isPrefix;
        public Key top;
        public Key next;
        public Text currentCQ;
        private boolean seeked = false;

        public TermSource(TermSource other) {
            this.iter = other.iter;
            this.term = other.term;
            this.termCond = other.termCond;
            this.seekColfams = other.seekColfams;
            this.column = other.column;
            this.top = other.top;
            this.next = other.next;
            this.currentCQ = other.currentCQ;
            this.isPrefix = other.isPrefix;
        }

        public TermSource(SortedKeyValueIterator<Key, Value> iter, TextColumn column) {
            this.iter = iter;
            this.column = column;
            this.term = column.getColumnFamily();
            this.termCond = column.getColumnQualifier();
            this.currentCQ = new Text(emptyByteArray);
            this.seekColfams = Collections.singletonList(new ArrayByteSequence(this.term.getBytes(), 0, this.term.getLength()));
        }

        public void seek(Range r) throws IOException {
            if (this.seeked) {
                if (this.next != null && !r.beforeStartKey(this.next)) {
                    if (this.next.getColumnFamily().equals((Object)this.term)) {
                        this.updateTop();
                    }
                } else if (this.iter.hasTop()) {
                    this.iter.seek(r, this.seekColfams, true);
                    this.updateTopNext();
                } else {
                    this.top = null;
                    this.next = null;
                }
            } else {
                this.iter.seek(r, this.seekColfams, true);
                this.updateTopNext();
                this.seeked = true;
            }
        }

        public void next() throws IOException {
            this.updateTop();
        }

        public void updateTop() throws IOException {
            this.top = this.next;
            if (this.next != null) {
                this.iter.next();
                this.next = this.iter.hasTop() ? (Key)this.iter.getTopKey() : null;
            }
        }

        public void updateTopNext() throws IOException {
            if (!this.iter.hasTop()) {
                this.top = null;
                this.next = null;
                return;
            }
            this.top = (Key)this.iter.getTopKey();
            this.iter.next();
            this.next = this.iter.hasTop() ? (Key)this.iter.getTopKey() : null;
        }

        public boolean hasTop() {
            return this.top != null;
        }

        public String getTermString() {
            return this.term == null ? new String("Iterator") : this.term.toString();
        }
    }
}

