/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.utils;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.parser.sparql.SPARQLParser;

@DefaultAnnotation(value={NonNull.class})
public class QueryInvestigator {
    private static final SPARQLParser PARSER = new SPARQLParser();

    private QueryInvestigator() {
    }

    public static boolean isConstruct(String sparql) throws MalformedQueryException {
        Objects.requireNonNull(sparql);
        try {
            PARSER.parseQuery(sparql, null);
            return Pattern.matches("[\\s\\S]*?construct\\s*?\\{[\\s\\S]*?\\}[\\s\\S]*?where\\s*\\{[\\s\\S]*?\\}", sparql.toLowerCase());
        }
        catch (MalformedQueryException queryE) {
            try {
                PARSER.parseUpdate(sparql, null);
                return false;
            }
            catch (MalformedQueryException updateE) {
                throw queryE;
            }
        }
    }

    public static boolean isInsertWhere(String sparql) throws MalformedQueryException {
        Objects.requireNonNull(sparql);
        try {
            PARSER.parseUpdate(sparql, null);
            return Pattern.matches("[\\s\\S]*?insert\\s*?\\{[\\s\\S]*?\\}[\\s\\S]*?where\\s*\\{[\\s\\S]*?\\}", sparql.toLowerCase());
        }
        catch (MalformedQueryException updateE) {
            try {
                PARSER.parseQuery(sparql, null);
                return false;
            }
            catch (MalformedQueryException queryE) {
                throw updateE;
            }
        }
    }
}

