/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.utils;

import com.google.common.base.Preconditions;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;

public class PeekingCloseableIteration<E, X extends Exception>
implements CloseableIteration<E, X> {
    private final CloseableIteration<E, X> iteration;
    private boolean hasPeeked;
    private E peekedElement;

    public PeekingCloseableIteration(CloseableIteration<E, X> iteration) {
        this.iteration = (CloseableIteration)Preconditions.checkNotNull(iteration);
    }

    public void close() throws X {
        this.iteration.close();
    }

    public boolean hasNext() throws X {
        return this.hasPeeked || this.iteration.hasNext();
    }

    public E next() throws X {
        if (!this.hasPeeked) {
            return (E)this.iteration.next();
        }
        E result = this.peekedElement;
        this.hasPeeked = false;
        this.peekedElement = null;
        return result;
    }

    public void remove() throws X {
        Preconditions.checkState((!this.hasPeeked ? 1 : 0) != 0, (Object)"Can't remove after you've peeked at next");
        this.iteration.remove();
    }

    public E peek() throws X {
        if (!this.hasPeeked) {
            this.peekedElement = this.iteration.next();
            this.hasPeeked = true;
        }
        return this.peekedElement;
    }
}

