/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.resolver.triple.impl;

import com.google.common.primitives.Bytes;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.rya.api.RdfCloudTripleStoreConstants;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.api.resolver.RyaContext;
import org.apache.rya.api.resolver.RyaTypeResolverException;
import org.apache.rya.api.resolver.triple.TripleRow;
import org.apache.rya.api.resolver.triple.TripleRowResolver;
import org.apache.rya.api.resolver.triple.TripleRowResolverException;

public class WholeRowHashedTripleResolver
implements TripleRowResolver {
    @Override
    public Map<RdfCloudTripleStoreConstants.TABLE_LAYOUT, TripleRow> serialize(RyaStatement stmt) throws TripleRowResolverException {
        try {
            RyaIRI subject = stmt.getSubject();
            RyaIRI predicate = stmt.getPredicate();
            RyaType object = stmt.getObject();
            RyaIRI context = stmt.getContext();
            Long timestamp = stmt.getTimestamp();
            byte[] columnVisibility = stmt.getColumnVisibility();
            String qualifer = stmt.getQualifer();
            byte[] qualBytes = qualifer == null ? RdfCloudTripleStoreConstants.EMPTY_BYTES : qualifer.getBytes(StandardCharsets.UTF_8);
            byte[] value = stmt.getValue();
            assert (subject != null && predicate != null && object != null);
            byte[] cf = context == null ? RdfCloudTripleStoreConstants.EMPTY_BYTES : context.getData().getBytes(StandardCharsets.UTF_8);
            HashMap<RdfCloudTripleStoreConstants.TABLE_LAYOUT, TripleRow> tripleRowMap = new HashMap<RdfCloudTripleStoreConstants.TABLE_LAYOUT, TripleRow>();
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] subjBytes = subject.getData().getBytes(StandardCharsets.UTF_8);
            byte[] subjHashBytes = md.digest(subjBytes);
            byte[] predBytes = predicate.getData().getBytes(StandardCharsets.UTF_8);
            byte[] predHashBytes = md.digest(predBytes);
            byte[][] objBytes = RyaContext.getInstance().serializeType(object);
            tripleRowMap.put(RdfCloudTripleStoreConstants.TABLE_LAYOUT.SPO, new TripleRow(Bytes.concat((byte[][])new byte[][]{Hex.encodeHexString((byte[])subjHashBytes).getBytes(StandardCharsets.UTF_8), RdfCloudTripleStoreConstants.DELIM_BYTES, subjBytes, RdfCloudTripleStoreConstants.DELIM_BYTES, predBytes, RdfCloudTripleStoreConstants.DELIM_BYTES, objBytes[0], objBytes[1]}), cf, qualBytes, timestamp, columnVisibility, value));
            tripleRowMap.put(RdfCloudTripleStoreConstants.TABLE_LAYOUT.PO, new TripleRow(Bytes.concat((byte[][])new byte[][]{Hex.encodeHexString((byte[])predHashBytes).getBytes(StandardCharsets.UTF_8), RdfCloudTripleStoreConstants.DELIM_BYTES, predBytes, RdfCloudTripleStoreConstants.DELIM_BYTES, objBytes[0], RdfCloudTripleStoreConstants.DELIM_BYTES, subjBytes, objBytes[1]}), cf, qualBytes, timestamp, columnVisibility, value));
            tripleRowMap.put(RdfCloudTripleStoreConstants.TABLE_LAYOUT.OSP, new TripleRow(Bytes.concat((byte[][])new byte[][]{objBytes[0], RdfCloudTripleStoreConstants.DELIM_BYTES, subjBytes, RdfCloudTripleStoreConstants.DELIM_BYTES, predBytes, objBytes[1]}), cf, qualBytes, timestamp, columnVisibility, value));
            return tripleRowMap;
        }
        catch (RyaTypeResolverException e) {
            throw new TripleRowResolverException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TripleRowResolverException(e);
        }
    }

    @Override
    public RyaStatement deserialize(RdfCloudTripleStoreConstants.TABLE_LAYOUT table_layout, TripleRow tripleRow) throws TripleRowResolverException {
        try {
            assert (tripleRow != null && table_layout != null);
            byte[] row = tripleRow.getRow();
            if (table_layout == RdfCloudTripleStoreConstants.TABLE_LAYOUT.SPO || table_layout == RdfCloudTripleStoreConstants.TABLE_LAYOUT.PO) {
                int hashStart = Bytes.indexOf((byte[])row, (byte)0);
                row = Arrays.copyOfRange(row, hashStart + 1, row.length);
            }
            int firstIndex = Bytes.indexOf((byte[])row, (byte)0);
            byte[] first = Arrays.copyOf(row, firstIndex);
            int secondIndex = Bytes.lastIndexOf((byte[])row, (byte)0);
            int typeIndex = Bytes.indexOf((byte[])row, (byte)1);
            byte[] second = Arrays.copyOfRange(row, firstIndex + 1, secondIndex);
            byte[] third = Arrays.copyOfRange(row, secondIndex + 1, typeIndex);
            byte[] type = Arrays.copyOfRange(row, typeIndex, row.length);
            byte[] columnFamily = tripleRow.getColumnFamily();
            boolean contextExists = columnFamily != null && columnFamily.length > 0;
            RyaIRI context = contextExists ? new RyaIRI(new String(columnFamily, StandardCharsets.UTF_8)) : null;
            byte[] columnQualifier = tripleRow.getColumnQualifier();
            String qualifier = columnQualifier != null && columnQualifier.length > 0 ? new String(columnQualifier, StandardCharsets.UTF_8) : null;
            Long timestamp = tripleRow.getTimestamp();
            byte[] columnVisibility = tripleRow.getColumnVisibility();
            byte[] value = tripleRow.getValue();
            switch (table_layout) {
                case SPO: {
                    byte[] obj = Bytes.concat((byte[][])new byte[][]{third, type});
                    return new RyaStatement(new RyaIRI(new String(first, StandardCharsets.UTF_8)), new RyaIRI(new String(second, StandardCharsets.UTF_8)), RyaContext.getInstance().deserialize(obj), context, qualifier, columnVisibility, value, timestamp);
                }
                case PO: {
                    byte[] obj = Bytes.concat((byte[][])new byte[][]{second, type});
                    return new RyaStatement(new RyaIRI(new String(third, StandardCharsets.UTF_8)), new RyaIRI(new String(first, StandardCharsets.UTF_8)), RyaContext.getInstance().deserialize(obj), context, qualifier, columnVisibility, value, timestamp);
                }
                case OSP: {
                    byte[] obj = Bytes.concat((byte[][])new byte[][]{first, type});
                    return new RyaStatement(new RyaIRI(new String(second, StandardCharsets.UTF_8)), new RyaIRI(new String(third, StandardCharsets.UTF_8)), RyaContext.getInstance().deserialize(obj), context, qualifier, columnVisibility, value, timestamp);
                }
            }
        }
        catch (RyaTypeResolverException e) {
            throw new TripleRowResolverException(e);
        }
        throw new TripleRowResolverException("TripleRow[" + tripleRow + "] with Table layout[" + (Object)((Object)table_layout) + "] is not deserializable");
    }
}

