/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.resolver.triple;

import java.util.Arrays;

public class TripleRow {
    private byte[] row;
    private byte[] columnFamily;
    private byte[] columnQualifier;
    private byte[] columnVisibility;
    private byte[] value;
    private Long timestamp;

    public TripleRow(byte[] row, byte[] columnFamily, byte[] columnQualifier) {
        this(row, columnFamily, columnQualifier, null, null, null);
    }

    public TripleRow(byte[] row, byte[] columnFamily, byte[] columnQualifier, Long timestamp, byte[] columnVisibility, byte[] value) {
        this.row = row;
        this.columnFamily = columnFamily;
        this.columnQualifier = columnQualifier;
        this.timestamp = timestamp != null ? timestamp : System.currentTimeMillis();
        this.columnVisibility = columnVisibility;
        this.value = value;
    }

    public byte[] getRow() {
        return this.row;
    }

    public byte[] getColumnFamily() {
        return this.columnFamily;
    }

    public byte[] getColumnQualifier() {
        return this.columnQualifier;
    }

    public byte[] getColumnVisibility() {
        return this.columnVisibility;
    }

    public byte[] getValue() {
        return this.value;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TripleRow tripleRow = (TripleRow)o;
        if (!Arrays.equals(this.columnFamily, tripleRow.columnFamily)) {
            return false;
        }
        if (!Arrays.equals(this.columnQualifier, tripleRow.columnQualifier)) {
            return false;
        }
        return Arrays.equals(this.row, tripleRow.row);
    }

    public int hashCode() {
        int result = this.row != null ? Arrays.hashCode(this.row) : 0;
        result = 31 * result + (this.columnFamily != null ? Arrays.hashCode(this.columnFamily) : 0);
        result = 31 * result + (this.columnQualifier != null ? Arrays.hashCode(this.columnQualifier) : 0);
        result = 31 * result + (this.columnVisibility != null ? Arrays.hashCode(this.columnVisibility) : 0);
        result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TripleRow{row=" + this.row + ", columnFamily=" + this.columnFamily + ", columnQualifier=" + this.columnQualifier + ", columnVisibility=" + this.columnVisibility + ", value=" + this.value + ", timestamp=" + this.timestamp + '}';
    }
}

