/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.resolver.impl;

import com.google.common.primitives.Bytes;
import java.nio.charset.StandardCharsets;
import org.apache.rya.api.RdfCloudTripleStoreConstants;
import org.apache.rya.api.domain.RyaRange;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.api.resolver.RyaTypeResolver;
import org.apache.rya.api.resolver.RyaTypeResolverException;
import org.apache.rya.api.utils.LiteralLanguageUtils;
import org.calrissian.mango.types.LexiTypeEncoders;
import org.calrissian.mango.types.TypeEncoder;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;

public class RyaTypeResolverImpl
implements RyaTypeResolver {
    public static final int PLAIN_LITERAL_MARKER = 3;
    public static final TypeEncoder<String, String> STRING_TYPE_ENCODER = LexiTypeEncoders.stringEncoder();
    protected byte markerByte;
    protected IRI dataType;
    protected byte[] markerBytes;

    public RyaTypeResolverImpl() {
        this(3, XMLSchema.STRING);
    }

    public RyaTypeResolverImpl(byte markerByte, IRI dataType) {
        this.setMarkerByte(markerByte);
        this.setRyaDataType(dataType);
    }

    public void setMarkerByte(byte markerByte) {
        this.markerByte = markerByte;
        this.markerBytes = new byte[]{markerByte};
    }

    @Override
    public byte getMarkerByte() {
        return this.markerByte;
    }

    @Override
    public RyaRange transformRange(RyaRange ryaRange) throws RyaTypeResolverException {
        return ryaRange;
    }

    @Override
    public byte[] serialize(RyaType ryaType) throws RyaTypeResolverException {
        byte[][] bytes = this.serializeType(ryaType);
        return Bytes.concat((byte[][])new byte[][]{bytes[0], bytes[1]});
    }

    @Override
    public byte[][] serializeType(RyaType ryaType) throws RyaTypeResolverException {
        StringBuilder dataBuilder = new StringBuilder();
        dataBuilder.append(ryaType.getData());
        String validatedLanguage = LiteralLanguageUtils.validateLanguage(ryaType.getLanguage(), this.dataType);
        if (validatedLanguage != null) {
            dataBuilder.append("@");
            dataBuilder.append(validatedLanguage);
        }
        byte[] bytes = this.serializeData(dataBuilder.toString()).getBytes(StandardCharsets.UTF_8);
        return new byte[][]{bytes, Bytes.concat((byte[][])new byte[][]{RdfCloudTripleStoreConstants.TYPE_DELIM_BYTES, this.markerBytes})};
    }

    @Override
    public IRI getRyaDataType() {
        return this.dataType;
    }

    public void setRyaDataType(IRI dataType) {
        this.dataType = dataType;
    }

    @Override
    public RyaType newInstance() {
        return new RyaType();
    }

    @Override
    public boolean deserializable(byte[] bytes) {
        return bytes != null && bytes.length >= 2 && bytes[bytes.length - 1] == this.getMarkerByte() && bytes[bytes.length - 2] == 1;
    }

    protected String serializeData(String data) throws RyaTypeResolverException {
        return (String)STRING_TYPE_ENCODER.encode((Object)data);
    }

    @Override
    public RyaType deserialize(byte[] bytes) throws RyaTypeResolverException {
        if (!this.deserializable(bytes)) {
            throw new RyaTypeResolverException("Bytes not deserializable");
        }
        RyaType rt = this.newInstance();
        rt.setDataType(this.getRyaDataType());
        String data = new String(bytes, 0, bytes.length - 2, StandardCharsets.UTF_8);
        if (RDF.LANGSTRING.equals((Object)rt.getDataType())) {
            int langDelimiterPos = data.lastIndexOf("@");
            String parsedData = data.substring(0, langDelimiterPos);
            String language = data.substring(langDelimiterPos + 1, data.length());
            if (language != null && Literals.isValidLanguageTag((String)language)) {
                rt.setLanguage(language);
            } else {
                rt.setLanguage("und");
            }
            data = parsedData;
        }
        rt.setData(this.deserializeData(data));
        return rt;
    }

    protected String deserializeData(String data) throws RyaTypeResolverException {
        return (String)STRING_TYPE_ENCODER.decode((Object)data);
    }
}

