/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.resolver.impl;

import org.apache.rya.api.resolver.RyaTypeResolverException;
import org.apache.rya.api.resolver.impl.RyaTypeResolverImpl;
import org.calrissian.mango.types.LexiTypeEncoders;
import org.calrissian.mango.types.TypeEncoder;
import org.calrissian.mango.types.exception.TypeDecodingException;
import org.calrissian.mango.types.exception.TypeEncodingException;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;

public class LongRyaTypeResolver
extends RyaTypeResolverImpl {
    public static final int LONG_LITERAL_MARKER = 4;
    public static final TypeEncoder<Long, String> LONG_STRING_TYPE_ENCODER = LexiTypeEncoders.longEncoder();

    public LongRyaTypeResolver() {
        super((byte)4, XMLSchema.LONG);
    }

    @Override
    protected String serializeData(String data) throws RyaTypeResolverException {
        try {
            return (String)LONG_STRING_TYPE_ENCODER.encode((Object)Long.parseLong(data));
        }
        catch (NumberFormatException e) {
            throw new RyaTypeResolverException("Exception occurred serializing data[" + data + "]", e);
        }
        catch (TypeEncodingException e) {
            throw new RyaTypeResolverException("Exception occurred serializing data[" + data + "]", e);
        }
    }

    @Override
    protected String deserializeData(String value) throws RyaTypeResolverException {
        try {
            return ((Long)LONG_STRING_TYPE_ENCODER.decode((Object)value)).toString();
        }
        catch (TypeDecodingException e) {
            throw new RyaTypeResolverException("Exception occurred deserializing data[" + value + "]", e);
        }
    }
}

