/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.resolver.impl;

import org.apache.rya.api.resolver.RyaTypeResolverException;
import org.apache.rya.api.resolver.impl.RyaTypeResolverImpl;
import org.calrissian.mango.types.LexiTypeEncoders;
import org.calrissian.mango.types.TypeEncoder;
import org.calrissian.mango.types.exception.TypeDecodingException;
import org.calrissian.mango.types.exception.TypeEncodingException;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;

public class FloatRyaTypeResolver
extends RyaTypeResolverImpl {
    public static final int FLOAT_LITERAL_MARKER = 11;
    public static final TypeEncoder<Float, String> FLOAT_TYPE_ENCODER = LexiTypeEncoders.floatEncoder();

    public FloatRyaTypeResolver() {
        super((byte)11, XMLSchema.FLOAT);
    }

    @Override
    protected String serializeData(String data) throws RyaTypeResolverException {
        try {
            float value = Float.parseFloat(data);
            return (String)FLOAT_TYPE_ENCODER.encode((Object)Float.valueOf(value));
        }
        catch (NumberFormatException e) {
            throw new RyaTypeResolverException("Exception occurred serializing data[" + data + "]", e);
        }
        catch (TypeEncodingException e) {
            throw new RyaTypeResolverException("Exception occurred serializing data[" + data + "]", e);
        }
    }

    @Override
    protected String deserializeData(String value) throws RyaTypeResolverException {
        try {
            return ((Float)FLOAT_TYPE_ENCODER.decode((Object)value)).toString();
        }
        catch (TypeDecodingException e) {
            throw new RyaTypeResolverException("Exception occurred deserializing data[" + value + "]", e);
        }
    }
}

