/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.resolver.impl;

import org.apache.rya.api.resolver.RyaTypeResolverException;
import org.apache.rya.api.resolver.impl.RyaTypeResolverImpl;
import org.calrissian.mango.types.LexiTypeEncoders;
import org.calrissian.mango.types.TypeEncoder;
import org.calrissian.mango.types.exception.TypeDecodingException;
import org.calrissian.mango.types.exception.TypeEncodingException;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;

public class DoubleRyaTypeResolver
extends RyaTypeResolverImpl {
    public static final int DOUBLE_LITERAL_MARKER = 6;
    public static final TypeEncoder<Double, String> DOUBLE_TYPE_ENCODER = LexiTypeEncoders.doubleEncoder();

    public DoubleRyaTypeResolver() {
        super((byte)6, XMLSchema.DOUBLE);
    }

    @Override
    protected String serializeData(String data) throws RyaTypeResolverException {
        try {
            double value = Double.parseDouble(data);
            return (String)DOUBLE_TYPE_ENCODER.encode((Object)value);
        }
        catch (NumberFormatException e) {
            throw new RyaTypeResolverException("Exception occurred serializing data[" + data + "]", e);
        }
        catch (TypeEncodingException e) {
            throw new RyaTypeResolverException("Exception occurred serializing data[" + data + "]", e);
        }
    }

    @Override
    protected String deserializeData(String value) throws RyaTypeResolverException {
        try {
            return ((Double)DOUBLE_TYPE_ENCODER.decode((Object)value)).toString();
        }
        catch (TypeDecodingException e) {
            throw new RyaTypeResolverException("Exception occurred deserializing data[" + value + "]", e);
        }
    }
}

