/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.resolver.impl;

import java.util.Date;
import org.apache.rya.api.resolver.RyaTypeResolverException;
import org.apache.rya.api.resolver.impl.RyaTypeResolverImpl;
import org.calrissian.mango.types.LexiTypeEncoders;
import org.calrissian.mango.types.TypeEncoder;
import org.calrissian.mango.types.exception.TypeDecodingException;
import org.calrissian.mango.types.exception.TypeEncodingException;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateTimeRyaTypeResolver
extends RyaTypeResolverImpl {
    public static final int DATETIME_LITERAL_MARKER = 7;
    public static final TypeEncoder<Date, String> DATE_STRING_TYPE_ENCODER = LexiTypeEncoders.dateEncoder();
    public static final DateTimeFormatter XMLDATETIME_PARSER = ISODateTimeFormat.dateTimeParser();
    public static final DateTimeFormatter UTC_XMLDATETIME_FORMATTER = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);

    public DateTimeRyaTypeResolver() {
        super((byte)7, XMLSchema.DATETIME);
    }

    @Override
    protected String serializeData(String data) throws RyaTypeResolverException {
        try {
            DateTime dateTime = DateTime.parse((String)data, (DateTimeFormatter)XMLDATETIME_PARSER);
            Date value = dateTime.toDate();
            return (String)DATE_STRING_TYPE_ENCODER.encode((Object)value);
        }
        catch (TypeEncodingException e) {
            throw new RyaTypeResolverException("Exception occurred serializing data[" + data + "]", e);
        }
    }

    @Override
    protected String deserializeData(String value) throws RyaTypeResolverException {
        try {
            Date date = (Date)DATE_STRING_TYPE_ENCODER.decode((Object)value);
            return UTC_XMLDATETIME_FORMATTER.print(date.getTime());
        }
        catch (TypeDecodingException e) {
            throw new RyaTypeResolverException("Exception occurred deserializing data[" + value + "]", e);
        }
    }
}

