/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.resolver.impl;

import com.google.common.primitives.Bytes;
import java.nio.charset.StandardCharsets;
import org.apache.rya.api.RdfCloudTripleStoreConstants;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.api.resolver.RyaTypeResolverException;
import org.apache.rya.api.resolver.impl.RyaTypeResolverImpl;
import org.apache.rya.api.utils.LiteralLanguageUtils;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.RDF;

public class CustomDatatypeResolver
extends RyaTypeResolverImpl {
    public static final int DT_LITERAL_MARKER = 8;

    public CustomDatatypeResolver() {
        super((byte)8, null);
    }

    @Override
    public byte[][] serializeType(RyaType ryaType) throws RyaTypeResolverException {
        StringBuilder dataBuilder = new StringBuilder();
        dataBuilder.append(ryaType.getData());
        String validatedLanguage = LiteralLanguageUtils.validateLanguage(ryaType.getLanguage(), ryaType.getDataType());
        if (validatedLanguage != null) {
            dataBuilder.append("@");
            dataBuilder.append(validatedLanguage);
        }
        byte[] bytes = this.serializeData(dataBuilder.toString()).getBytes(StandardCharsets.UTF_8);
        return new byte[][]{bytes, Bytes.concat((byte[][])new byte[][]{RdfCloudTripleStoreConstants.TYPE_DELIM_BYTES, ryaType.getDataType().stringValue().getBytes(StandardCharsets.UTF_8), RdfCloudTripleStoreConstants.TYPE_DELIM_BYTES, this.markerBytes})};
    }

    @Override
    public byte[] serialize(RyaType ryaType) throws RyaTypeResolverException {
        byte[][] bytes = this.serializeType(ryaType);
        return Bytes.concat((byte[][])new byte[][]{bytes[0], bytes[1]});
    }

    @Override
    public RyaType deserialize(byte[] bytes) throws RyaTypeResolverException {
        if (!this.deserializable(bytes)) {
            throw new RyaTypeResolverException("Bytes not deserializable");
        }
        RyaType rt = this.newInstance();
        int length = bytes.length;
        int indexOfType = Bytes.indexOf((byte[])bytes, (byte)1);
        if (indexOfType < 1) {
            throw new RyaTypeResolverException("Not a datatype literal");
        }
        String data = this.deserializeData(new String(bytes, 0, indexOfType, StandardCharsets.UTF_8));
        rt.setDataType(SimpleValueFactory.getInstance().createIRI(new String(bytes, indexOfType + 1, length - indexOfType - 3, StandardCharsets.UTF_8)));
        if (RDF.LANGSTRING.equals((Object)rt.getDataType())) {
            int langDelimiterPos = data.lastIndexOf("@");
            String parsedData = data.substring(0, langDelimiterPos);
            String language = data.substring(langDelimiterPos + 1, data.length());
            if (language != null && Literals.isValidLanguageTag((String)language)) {
                rt.setLanguage(language);
            } else {
                rt.setLanguage("und");
            }
            data = parsedData;
        }
        rt.setData(data);
        return rt;
    }
}

