/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.resolver.impl;

import org.apache.rya.api.resolver.RyaTypeResolverException;
import org.apache.rya.api.resolver.impl.RyaTypeResolverImpl;
import org.calrissian.mango.types.LexiTypeEncoders;
import org.calrissian.mango.types.TypeEncoder;
import org.calrissian.mango.types.exception.TypeDecodingException;
import org.calrissian.mango.types.exception.TypeEncodingException;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;

public class ByteRyaTypeResolver
extends RyaTypeResolverImpl {
    public static final int LITERAL_MARKER = 9;
    public static final TypeEncoder<Byte, String> BYTE_STRING_TYPE_ENCODER = LexiTypeEncoders.byteEncoder();

    public ByteRyaTypeResolver() {
        super((byte)9, XMLSchema.BYTE);
    }

    @Override
    protected String serializeData(String data) throws RyaTypeResolverException {
        try {
            Byte value = Byte.parseByte(data);
            return (String)BYTE_STRING_TYPE_ENCODER.encode((Object)value);
        }
        catch (NumberFormatException e) {
            throw new RyaTypeResolverException("Exception occurred serializing data[" + data + "]", e);
        }
        catch (TypeEncodingException e) {
            throw new RyaTypeResolverException("Exception occurred serializing data[" + data + "]", e);
        }
    }

    @Override
    protected String deserializeData(String value) throws RyaTypeResolverException {
        try {
            return ((Byte)BYTE_STRING_TYPE_ENCODER.decode((Object)value)).toString();
        }
        catch (TypeDecodingException e) {
            throw new RyaTypeResolverException("Exception occurred deserializing data[" + value + "]", e);
        }
    }
}

