/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.resolver.impl;

import org.apache.rya.api.resolver.RyaTypeResolverException;
import org.apache.rya.api.resolver.impl.RyaTypeResolverImpl;
import org.calrissian.mango.types.LexiTypeEncoders;
import org.calrissian.mango.types.TypeEncoder;
import org.calrissian.mango.types.exception.TypeDecodingException;
import org.calrissian.mango.types.exception.TypeEncodingException;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;

public class BooleanRyaTypeResolver
extends RyaTypeResolverImpl {
    public static final int BOOLEAN_LITERAL_MARKER = 10;
    public static final TypeEncoder<Boolean, String> BOOLEAN_TYPE_ENCODER = LexiTypeEncoders.booleanEncoder();

    public BooleanRyaTypeResolver() {
        super((byte)10, XMLSchema.BOOLEAN);
    }

    @Override
    protected String serializeData(String data) throws RyaTypeResolverException {
        try {
            boolean value = Boolean.parseBoolean(data);
            return (String)BOOLEAN_TYPE_ENCODER.encode((Object)value);
        }
        catch (TypeEncodingException e) {
            throw new RyaTypeResolverException("Exception occurred serializing data[" + data + "]", e);
        }
    }

    @Override
    protected String deserializeData(String value) throws RyaTypeResolverException {
        try {
            return ((Boolean)BOOLEAN_TYPE_ENCODER.decode((Object)value)).toString();
        }
        catch (TypeDecodingException e) {
            throw new RyaTypeResolverException("Exception occurred deserializing data[" + value + "]", e);
        }
    }
}

