/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.resolver;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.RdfCloudTripleStoreConstants;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.api.query.strategy.TriplePatternStrategy;
import org.apache.rya.api.query.strategy.wholerow.HashedPoWholeRowTriplePatternStrategy;
import org.apache.rya.api.query.strategy.wholerow.HashedSpoWholeRowTriplePatternStrategy;
import org.apache.rya.api.query.strategy.wholerow.NullRowTriplePatternStrategy;
import org.apache.rya.api.query.strategy.wholerow.OspWholeRowTriplePatternStrategy;
import org.apache.rya.api.query.strategy.wholerow.PoWholeRowTriplePatternStrategy;
import org.apache.rya.api.query.strategy.wholerow.SpoWholeRowTriplePatternStrategy;
import org.apache.rya.api.resolver.triple.TripleRow;
import org.apache.rya.api.resolver.triple.TripleRowResolver;
import org.apache.rya.api.resolver.triple.TripleRowResolverException;
import org.apache.rya.api.resolver.triple.impl.WholeRowHashedTripleResolver;
import org.apache.rya.api.resolver.triple.impl.WholeRowTripleResolver;

public class RyaTripleContext {
    public Log logger = LogFactory.getLog(RyaTripleContext.class);
    private TripleRowResolver tripleResolver;
    private final List<TriplePatternStrategy> triplePatternStrategyList = new ArrayList<TriplePatternStrategy>();

    public RyaTripleContext(boolean addPrefixHash) {
        this.addDefaultTriplePatternStrategies(addPrefixHash);
        this.tripleResolver = addPrefixHash ? new WholeRowHashedTripleResolver() : new WholeRowTripleResolver();
    }

    public static synchronized RyaTripleContext getInstance(RdfCloudTripleStoreConfiguration conf) {
        if (conf.isPrefixRowsWithHash().booleanValue()) {
            return RyaTripleContextHolder.HASHED_INSTANCE;
        }
        return RyaTripleContextHolder.INSTANCE;
    }

    public Map<RdfCloudTripleStoreConstants.TABLE_LAYOUT, TripleRow> serializeTriple(RyaStatement statement) throws TripleRowResolverException {
        return this.getTripleResolver().serialize(statement);
    }

    public RyaStatement deserializeTriple(RdfCloudTripleStoreConstants.TABLE_LAYOUT table_layout, TripleRow tripleRow) throws TripleRowResolverException {
        return this.getTripleResolver().deserialize(table_layout, tripleRow);
    }

    protected void addDefaultTriplePatternStrategies(boolean addPrefixHash) {
        if (addPrefixHash) {
            this.triplePatternStrategyList.add(new HashedSpoWholeRowTriplePatternStrategy());
            this.triplePatternStrategyList.add(new HashedPoWholeRowTriplePatternStrategy());
        } else {
            this.triplePatternStrategyList.add(new SpoWholeRowTriplePatternStrategy());
            this.triplePatternStrategyList.add(new PoWholeRowTriplePatternStrategy());
            this.triplePatternStrategyList.add(new NullRowTriplePatternStrategy());
        }
        this.triplePatternStrategyList.add(new OspWholeRowTriplePatternStrategy());
    }

    public TriplePatternStrategy retrieveStrategy(RyaIRI subject, RyaIRI predicate, RyaType object, RyaIRI context) {
        for (TriplePatternStrategy strategy : this.triplePatternStrategyList) {
            if (!strategy.handles(subject, predicate, object, context)) continue;
            return strategy;
        }
        return null;
    }

    public TriplePatternStrategy retrieveStrategy(RyaStatement stmt) {
        return this.retrieveStrategy(stmt.getSubject(), stmt.getPredicate(), stmt.getObject(), stmt.getContext());
    }

    public TriplePatternStrategy retrieveStrategy(RdfCloudTripleStoreConstants.TABLE_LAYOUT layout) {
        for (TriplePatternStrategy strategy : this.triplePatternStrategyList) {
            if (!strategy.getLayout().equals((Object)layout)) continue;
            return strategy;
        }
        return null;
    }

    public TripleRowResolver getTripleResolver() {
        return this.tripleResolver;
    }

    public void setTripleResolver(TripleRowResolver tripleResolver) {
        this.tripleResolver = tripleResolver;
    }

    private static class RyaTripleContextHolder {
        public static final RyaTripleContext INSTANCE = new RyaTripleContext(false);
        public static final RyaTripleContext HASHED_INSTANCE = new RyaTripleContext(true);

        private RyaTripleContextHolder() {
        }
    }
}

