/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.resolver;

import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.domain.RyaType;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;

public class RyaToRdfConversions {
    private static final ValueFactory VF = SimpleValueFactory.getInstance();

    public static IRI convertIRI(RyaIRI ryaIri) {
        return VF.createIRI(ryaIri.getData());
    }

    private static IRI convertIRI(RyaType ryaType) {
        return VF.createIRI(ryaType.getData());
    }

    public static Literal convertLiteral(RyaType ryaType) {
        if (XMLSchema.STRING.equals((Object)ryaType.getDataType())) {
            return VF.createLiteral(ryaType.getData());
        }
        if (RDF.LANGSTRING.equals((Object)ryaType.getDataType())) {
            String data = ryaType.getData();
            String language = ryaType.getLanguage();
            if (language != null && Literals.isValidLanguageTag((String)language)) {
                return VF.createLiteral(data, language);
            }
            return VF.createLiteral(data, "und");
        }
        return VF.createLiteral(ryaType.getData(), ryaType.getDataType());
    }

    public static Value convertValue(RyaType ryaType) {
        return ryaType instanceof RyaIRI || ryaType.getDataType().equals((Object)XMLSchema.ANYURI) ? RyaToRdfConversions.convertIRI(ryaType) : RyaToRdfConversions.convertLiteral(ryaType);
    }

    public static Statement convertStatement(RyaStatement ryaStatement) {
        assert (ryaStatement != null);
        if (ryaStatement.getContext() != null) {
            return VF.createStatement((Resource)RyaToRdfConversions.convertIRI(ryaStatement.getSubject()), RyaToRdfConversions.convertIRI(ryaStatement.getPredicate()), RyaToRdfConversions.convertValue(ryaStatement.getObject()), (Resource)RyaToRdfConversions.convertIRI(ryaStatement.getContext()));
        }
        return VF.createStatement((Resource)RyaToRdfConversions.convertIRI(ryaStatement.getSubject()), RyaToRdfConversions.convertIRI(ryaStatement.getPredicate()), RyaToRdfConversions.convertValue(ryaStatement.getObject()));
    }
}

