/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.resolver;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.rya.api.domain.RyaRange;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.api.resolver.RyaTypeResolver;
import org.apache.rya.api.resolver.RyaTypeResolverException;
import org.apache.rya.api.resolver.RyaTypeResolverMapping;
import org.apache.rya.api.resolver.impl.BooleanRyaTypeResolver;
import org.apache.rya.api.resolver.impl.ByteRyaTypeResolver;
import org.apache.rya.api.resolver.impl.CustomDatatypeResolver;
import org.apache.rya.api.resolver.impl.DateTimeRyaTypeResolver;
import org.apache.rya.api.resolver.impl.DoubleRyaTypeResolver;
import org.apache.rya.api.resolver.impl.FloatRyaTypeResolver;
import org.apache.rya.api.resolver.impl.IntegerRyaTypeResolver;
import org.apache.rya.api.resolver.impl.LongRyaTypeResolver;
import org.apache.rya.api.resolver.impl.RyaIRIResolver;
import org.apache.rya.api.resolver.impl.RyaTypeResolverImpl;
import org.apache.rya.api.resolver.impl.ServiceBackedRyaTypeResolverMappings;
import org.apache.rya.api.resolver.impl.ShortRyaTypeResolver;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RyaContext {
    public Logger logger = LoggerFactory.getLogger(RyaContext.class);
    private final Map<IRI, RyaTypeResolver> uriToResolver = new HashMap<IRI, RyaTypeResolver>();
    private final Map<Byte, RyaTypeResolver> byteToResolver = new HashMap<Byte, RyaTypeResolver>();
    private RyaTypeResolver defaultResolver = new CustomDatatypeResolver();

    private RyaContext() {
        this.addDefaultMappings();
    }

    protected void addDefaultMappings() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Adding default mappings");
        }
        this.addRyaTypeResolverMapping(new RyaTypeResolverMapping(new RyaTypeResolverImpl()));
        this.addRyaTypeResolverMapping(new RyaTypeResolverMapping(new RyaIRIResolver()));
        this.addRyaTypeResolverMapping(new RyaTypeResolverMapping(new DateTimeRyaTypeResolver()));
        this.addRyaTypeResolverMapping(new RyaTypeResolverMapping(new DoubleRyaTypeResolver()));
        this.addRyaTypeResolverMapping(new RyaTypeResolverMapping(new FloatRyaTypeResolver()));
        this.addRyaTypeResolverMapping(new RyaTypeResolverMapping(new IntegerRyaTypeResolver()));
        this.addRyaTypeResolverMapping(new RyaTypeResolverMapping(new ShortRyaTypeResolver()));
        this.addRyaTypeResolverMapping(new RyaTypeResolverMapping(new LongRyaTypeResolver()));
        this.addRyaTypeResolverMapping(new RyaTypeResolverMapping(new BooleanRyaTypeResolver()));
        this.addRyaTypeResolverMapping(new RyaTypeResolverMapping(new ByteRyaTypeResolver()));
        this.uriToResolver.put(XMLSchema.INT, new IntegerRyaTypeResolver());
        this.addRyaTypeResolverMappings(new ServiceBackedRyaTypeResolverMappings().getResolvers());
    }

    public static synchronized RyaContext getInstance() {
        return RyaContextHolder.INSTANCE;
    }

    public RyaTypeResolver retrieveResolver(IRI datatype) {
        RyaTypeResolver ryaTypeResolver = this.uriToResolver.get(datatype);
        if (ryaTypeResolver == null) {
            return this.defaultResolver;
        }
        return ryaTypeResolver;
    }

    public RyaTypeResolver retrieveResolver(byte markerByte) {
        RyaTypeResolver ryaTypeResolver = this.byteToResolver.get(markerByte);
        if (ryaTypeResolver == null) {
            return this.defaultResolver;
        }
        return ryaTypeResolver;
    }

    public byte[] serialize(RyaType ryaType) throws RyaTypeResolverException {
        RyaTypeResolver ryaTypeResolver = this.retrieveResolver(ryaType.getDataType());
        if (ryaTypeResolver != null) {
            return ryaTypeResolver.serialize(ryaType);
        }
        return null;
    }

    public byte[][] serializeType(RyaType ryaType) throws RyaTypeResolverException {
        RyaTypeResolver ryaTypeResolver = this.retrieveResolver(ryaType.getDataType());
        if (ryaTypeResolver != null) {
            return ryaTypeResolver.serializeType(ryaType);
        }
        return null;
    }

    public RyaType deserialize(byte[] bytes) throws RyaTypeResolverException {
        RyaTypeResolver ryaTypeResolver = this.retrieveResolver(bytes[bytes.length - 1]);
        if (ryaTypeResolver != null) {
            return ryaTypeResolver.deserialize(bytes);
        }
        return null;
    }

    public void addRyaTypeResolverMapping(RyaTypeResolverMapping mapping) {
        if (!this.uriToResolver.containsKey(mapping.getRyaDataType())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("addRyaTypeResolverMapping uri:[" + mapping.getRyaDataType() + "] byte:[" + mapping.getMarkerByte() + "] for mapping[" + mapping + "]");
            }
            this.uriToResolver.put(mapping.getRyaDataType(), mapping.getRyaTypeResolver());
            this.byteToResolver.put(mapping.getMarkerByte(), mapping.getRyaTypeResolver());
        } else {
            this.logger.warn("Could not add ryaType mapping because one already exists. uri:[" + mapping.getRyaDataType() + "] byte:[" + mapping.getMarkerByte() + "] for mapping[" + mapping + "]");
        }
    }

    public void addRyaTypeResolverMappings(List<RyaTypeResolverMapping> mappings) {
        for (RyaTypeResolverMapping mapping : mappings) {
            this.addRyaTypeResolverMapping(mapping);
        }
    }

    public RyaTypeResolver removeRyaTypeResolver(IRI dataType) {
        RyaTypeResolver ryaTypeResolver = this.uriToResolver.remove(dataType);
        if (ryaTypeResolver != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Removing ryaType Resolver uri[" + dataType + "] + [" + ryaTypeResolver + "]");
            }
            this.byteToResolver.remove(ryaTypeResolver.getMarkerByte());
            return ryaTypeResolver;
        }
        return null;
    }

    public RyaTypeResolver removeRyaTypeResolver(byte markerByte) {
        RyaTypeResolver ryaTypeResolver = this.byteToResolver.remove(markerByte);
        if (ryaTypeResolver != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Removing ryaType Resolver byte[" + markerByte + "] + [" + ryaTypeResolver + "]");
            }
            this.uriToResolver.remove(ryaTypeResolver.getRyaDataType());
            return ryaTypeResolver;
        }
        return null;
    }

    public RyaRange transformRange(RyaRange range) throws RyaTypeResolverException {
        RyaTypeResolver ryaTypeResolver = this.retrieveResolver(range.getStart().getDataType());
        if (ryaTypeResolver != null) {
            return ryaTypeResolver.transformRange(range);
        }
        return range;
    }

    public RyaTypeResolver getDefaultResolver() {
        return this.defaultResolver;
    }

    public void setDefaultResolver(RyaTypeResolver defaultResolver) {
        this.defaultResolver = defaultResolver;
    }

    private static class RyaContextHolder {
        public static final RyaContext INSTANCE = new RyaContext();

        private RyaContextHolder() {
        }
    }
}

