/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.resolver;

import org.apache.log4j.Logger;
import org.apache.rya.api.domain.RangeIRI;
import org.apache.rya.api.domain.RangeValue;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaIRIRange;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.api.domain.RyaTypeRange;
import org.apache.rya.api.log.LogUtils;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Literals;

public class RdfToRyaConversions {
    private static final Logger log = Logger.getLogger(RdfToRyaConversions.class);

    public static RyaIRI convertIRI(IRI iri) {
        if (iri == null) {
            return null;
        }
        if (iri instanceof RangeIRI) {
            RangeIRI riri = (RangeIRI)iri;
            return new RyaIRIRange(RdfToRyaConversions.convertIRI((IRI)riri.getStart()), RdfToRyaConversions.convertIRI((IRI)riri.getEnd()));
        }
        return new RyaIRI(iri.stringValue());
    }

    public static RyaType convertLiteral(Literal literal) {
        if (literal == null) {
            return null;
        }
        if (literal.getDatatype() != null) {
            if (Literals.isLanguageLiteral((Literal)literal)) {
                String language = (String)literal.getLanguage().get();
                if (Literals.isValidLanguageTag((String)language)) {
                    return new RyaType(literal.getDatatype(), literal.stringValue(), language);
                }
                log.warn((Object)("Invalid language (" + LogUtils.clean(language) + ") found in Literal. Defaulting to: " + "und"));
                return new RyaType(literal.getDatatype(), literal.stringValue(), "und");
            }
            return new RyaType(literal.getDatatype(), literal.stringValue());
        }
        return new RyaType(literal.stringValue());
    }

    public static RyaType convertValue(Value value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Resource) {
            return RdfToRyaConversions.convertResource((Resource)value);
        }
        if (value instanceof Literal) {
            return RdfToRyaConversions.convertLiteral((Literal)value);
        }
        if (value instanceof RangeValue) {
            RangeValue rv = (RangeValue)value;
            if (rv.getStart() instanceof IRI) {
                return new RyaIRIRange(RdfToRyaConversions.convertIRI((IRI)rv.getStart()), RdfToRyaConversions.convertIRI((IRI)rv.getEnd()));
            }
            return new RyaTypeRange(RdfToRyaConversions.convertLiteral((Literal)rv.getStart()), RdfToRyaConversions.convertLiteral((Literal)rv.getEnd()));
        }
        return null;
    }

    public static RyaIRI convertResource(Resource resource) {
        if (resource == null) {
            return null;
        }
        if (resource instanceof BNode) {
            return new RyaIRI("urn:org.apache.rya/bnode/2012/07#" + ((BNode)resource).getID());
        }
        return RdfToRyaConversions.convertIRI((IRI)resource);
    }

    public static RyaStatement convertStatement(Statement statement) {
        if (statement == null) {
            return null;
        }
        Resource subject = statement.getSubject();
        IRI predicate = statement.getPredicate();
        Value object = statement.getObject();
        Resource context = statement.getContext();
        return new RyaStatement(RdfToRyaConversions.convertResource(subject), RdfToRyaConversions.convertIRI(predicate), RdfToRyaConversions.convertValue(object), RdfToRyaConversions.convertResource(context));
    }
}

