/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.query.strategy.wholerow;

import com.google.common.primitives.Bytes;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.RdfCloudTripleStoreConstants;
import org.apache.rya.api.RdfCloudTripleStoreUtils;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaRange;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.api.query.strategy.AbstractTriplePatternStrategy;
import org.apache.rya.api.query.strategy.ByteRange;
import org.apache.rya.api.resolver.RyaContext;
import org.apache.rya.api.resolver.RyaTypeResolverException;

public class OspWholeRowTriplePatternStrategy
extends AbstractTriplePatternStrategy {
    @Override
    public RdfCloudTripleStoreConstants.TABLE_LAYOUT getLayout() {
        return RdfCloudTripleStoreConstants.TABLE_LAYOUT.OSP;
    }

    @Override
    public Map.Entry<RdfCloudTripleStoreConstants.TABLE_LAYOUT, ByteRange> defineRange(RyaIRI subject, RyaIRI predicate, RyaType object, RyaIRI context, RdfCloudTripleStoreConfiguration conf) throws IOException {
        try {
            byte[] stop;
            byte[] start;
            if (!this.handles(subject, predicate, object, context)) {
                return null;
            }
            RyaContext ryaContext = RyaContext.getInstance();
            RdfCloudTripleStoreConstants.TABLE_LAYOUT table_layout = RdfCloudTripleStoreConstants.TABLE_LAYOUT.OSP;
            if (subject != null) {
                if (subject instanceof RyaRange) {
                    RyaRange ru = (RyaRange)((Object)subject);
                    ru = ryaContext.transformRange(ru);
                    byte[] subjStartBytes = ru.getStart().getData().getBytes(StandardCharsets.UTF_8);
                    byte[] subjEndBytes = ru.getStop().getData().getBytes(StandardCharsets.UTF_8);
                    byte[] objBytes = ryaContext.serializeType(object)[0];
                    start = Bytes.concat((byte[][])new byte[][]{objBytes, RdfCloudTripleStoreConstants.DELIM_BYTES, subjStartBytes});
                    stop = Bytes.concat((byte[][])new byte[][]{objBytes, RdfCloudTripleStoreConstants.DELIM_BYTES, subjEndBytes, RdfCloudTripleStoreConstants.DELIM_BYTES, RdfCloudTripleStoreConstants.LAST_BYTES});
                } else {
                    byte[] objBytes = ryaContext.serializeType(object)[0];
                    start = Bytes.concat((byte[][])new byte[][]{objBytes, RdfCloudTripleStoreConstants.DELIM_BYTES, subject.getData().getBytes(StandardCharsets.UTF_8), RdfCloudTripleStoreConstants.DELIM_BYTES});
                    stop = Bytes.concat((byte[][])new byte[][]{start, RdfCloudTripleStoreConstants.LAST_BYTES});
                }
            } else if (object instanceof RyaRange) {
                RyaRange rv = (RyaRange)((Object)object);
                rv = ryaContext.transformRange(rv);
                start = ryaContext.serializeType(rv.getStart())[0];
                stop = Bytes.concat((byte[][])new byte[][]{ryaContext.serializeType(rv.getStop())[0], RdfCloudTripleStoreConstants.DELIM_BYTES, RdfCloudTripleStoreConstants.LAST_BYTES});
            } else {
                start = Bytes.concat((byte[][])new byte[][]{ryaContext.serializeType(object)[0], RdfCloudTripleStoreConstants.DELIM_BYTES});
                stop = Bytes.concat((byte[][])new byte[][]{start, RdfCloudTripleStoreConstants.LAST_BYTES});
            }
            return new RdfCloudTripleStoreUtils.CustomEntry<RdfCloudTripleStoreConstants.TABLE_LAYOUT, ByteRange>(table_layout, new ByteRange(start, stop));
        }
        catch (RyaTypeResolverException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean handles(RyaIRI subject, RyaIRI predicate, RyaType object, RyaIRI context) {
        return object != null && (!(object instanceof RyaRange) || predicate == null && subject == null);
    }
}

