/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.query.strategy.wholerow;

import com.google.common.primitives.Bytes;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.RdfCloudTripleStoreConstants;
import org.apache.rya.api.RdfCloudTripleStoreUtils;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaIRIRange;
import org.apache.rya.api.domain.RyaRange;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.api.query.strategy.ByteRange;
import org.apache.rya.api.query.strategy.wholerow.AbstractHashedTriplePatternStrategy;
import org.apache.rya.api.resolver.RyaContext;
import org.apache.rya.api.resolver.RyaTypeResolverException;

public class HashedSpoWholeRowTriplePatternStrategy
extends AbstractHashedTriplePatternStrategy {
    @Override
    public RdfCloudTripleStoreConstants.TABLE_LAYOUT getLayout() {
        return RdfCloudTripleStoreConstants.TABLE_LAYOUT.SPO;
    }

    @Override
    public Map.Entry<RdfCloudTripleStoreConstants.TABLE_LAYOUT, ByteRange> defineRange(RyaIRI subject, RyaIRI predicate, RyaType object, RyaIRI context, RdfCloudTripleStoreConfiguration conf) throws IOException {
        try {
            byte[] stop;
            byte[] start;
            if (!this.handles(subject, predicate, object, context)) {
                return null;
            }
            MessageDigest md = MessageDigest.getInstance("MD5");
            RyaContext ryaContext = RyaContext.getInstance();
            RdfCloudTripleStoreConstants.TABLE_LAYOUT table_layout = RdfCloudTripleStoreConstants.TABLE_LAYOUT.SPO;
            if (predicate != null) {
                if (object != null) {
                    if (object instanceof RyaRange) {
                        RyaRange rv = (RyaRange)((Object)object);
                        rv = ryaContext.transformRange(rv);
                        byte[] objStartBytes = ryaContext.serializeType(rv.getStart())[0];
                        byte[] objEndBytes = ryaContext.serializeType(rv.getStop())[0];
                        byte[] subjBytes = subject.getData().getBytes(StandardCharsets.UTF_8);
                        byte[] hashSubj = Hex.encodeHexString((byte[])md.digest(subjBytes)).getBytes(StandardCharsets.UTF_8);
                        byte[] predBytes = predicate.getData().getBytes(StandardCharsets.UTF_8);
                        start = Bytes.concat((byte[][])new byte[][]{hashSubj, RdfCloudTripleStoreConstants.DELIM_BYTES, subjBytes, RdfCloudTripleStoreConstants.DELIM_BYTES, predBytes, RdfCloudTripleStoreConstants.DELIM_BYTES, objStartBytes});
                        stop = Bytes.concat((byte[][])new byte[][]{hashSubj, RdfCloudTripleStoreConstants.DELIM_BYTES, subjBytes, RdfCloudTripleStoreConstants.DELIM_BYTES, predBytes, RdfCloudTripleStoreConstants.DELIM_BYTES, objEndBytes, RdfCloudTripleStoreConstants.DELIM_BYTES, RdfCloudTripleStoreConstants.LAST_BYTES});
                    } else {
                        byte[] subjBytes = subject.getData().getBytes(StandardCharsets.UTF_8);
                        byte[] hashSubj = Hex.encodeHexString((byte[])md.digest(subjBytes)).getBytes(StandardCharsets.UTF_8);
                        byte[] objBytes = ryaContext.serializeType(object)[0];
                        start = Bytes.concat((byte[][])new byte[][]{hashSubj, RdfCloudTripleStoreConstants.DELIM_BYTES, subjBytes, RdfCloudTripleStoreConstants.DELIM_BYTES, predicate.getData().getBytes(StandardCharsets.UTF_8), RdfCloudTripleStoreConstants.DELIM_BYTES, objBytes, RdfCloudTripleStoreConstants.TYPE_DELIM_BYTES});
                        stop = Bytes.concat((byte[][])new byte[][]{start, RdfCloudTripleStoreConstants.LAST_BYTES});
                    }
                } else if (predicate instanceof RyaRange) {
                    RyaRange rv = (RyaRange)((Object)predicate);
                    rv = ryaContext.transformRange(rv);
                    byte[] subjBytes = subject.getData().getBytes(StandardCharsets.UTF_8);
                    byte[] hashSubj = Hex.encodeHexString((byte[])md.digest(subjBytes)).getBytes(StandardCharsets.UTF_8);
                    byte[] predStartBytes = rv.getStart().getData().getBytes(StandardCharsets.UTF_8);
                    byte[] predStopBytes = rv.getStop().getData().getBytes(StandardCharsets.UTF_8);
                    start = Bytes.concat((byte[][])new byte[][]{hashSubj, RdfCloudTripleStoreConstants.DELIM_BYTES, subjBytes, RdfCloudTripleStoreConstants.DELIM_BYTES, predStartBytes});
                    stop = Bytes.concat((byte[][])new byte[][]{hashSubj, RdfCloudTripleStoreConstants.DELIM_BYTES, subjBytes, RdfCloudTripleStoreConstants.DELIM_BYTES, predStopBytes, RdfCloudTripleStoreConstants.DELIM_BYTES, RdfCloudTripleStoreConstants.LAST_BYTES});
                } else {
                    byte[] subjBytes = subject.getData().getBytes(StandardCharsets.UTF_8);
                    byte[] hashSubj = Hex.encodeHexString((byte[])md.digest(subjBytes)).getBytes(StandardCharsets.UTF_8);
                    start = Bytes.concat((byte[][])new byte[][]{hashSubj, RdfCloudTripleStoreConstants.DELIM_BYTES, subjBytes, RdfCloudTripleStoreConstants.DELIM_BYTES, predicate.getData().getBytes(StandardCharsets.UTF_8), RdfCloudTripleStoreConstants.DELIM_BYTES});
                    stop = Bytes.concat((byte[][])new byte[][]{start, RdfCloudTripleStoreConstants.LAST_BYTES});
                }
            } else {
                byte[] subjBytes = subject.getData().getBytes(StandardCharsets.UTF_8);
                byte[] hashSubj = Hex.encodeHexString((byte[])md.digest(subjBytes)).getBytes(StandardCharsets.UTF_8);
                start = Bytes.concat((byte[][])new byte[][]{hashSubj, RdfCloudTripleStoreConstants.DELIM_BYTES, subjBytes, RdfCloudTripleStoreConstants.DELIM_BYTES});
                stop = Bytes.concat((byte[][])new byte[][]{start, RdfCloudTripleStoreConstants.LAST_BYTES});
            }
            return new RdfCloudTripleStoreUtils.CustomEntry<RdfCloudTripleStoreConstants.TABLE_LAYOUT, ByteRange>(table_layout, new ByteRange(start, stop));
        }
        catch (RyaTypeResolverException e) {
            throw new IOException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean handles(RyaIRI subject, RyaIRI predicate, RyaType object, RyaIRI context) {
        return subject != null && !(subject instanceof RyaIRIRange) && (predicate != null && !(predicate instanceof RyaIRIRange) || object == null);
    }
}

