/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.query.strategy.wholerow;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import org.apache.rya.api.RdfCloudTripleStoreConstants;
import org.apache.rya.api.query.strategy.AbstractTriplePatternStrategy;
import org.apache.rya.api.query.strategy.TriplePatternStrategy;
import org.apache.rya.api.resolver.triple.TripleRowRegex;

public abstract class AbstractHashedTriplePatternStrategy
extends AbstractTriplePatternStrategy
implements TriplePatternStrategy {
    public static final String HASHED_ALL_REGEX = "([0-9a-f]{32})\u0000";

    @Override
    public abstract RdfCloudTripleStoreConstants.TABLE_LAYOUT getLayout();

    @Override
    public TripleRowRegex buildRegex(String subject, String predicate, String object, String context, byte[] objectTypeInfo) {
        RdfCloudTripleStoreConstants.TABLE_LAYOUT table_layout = this.getLayout();
        Preconditions.checkNotNull((Object)((Object)table_layout));
        if (table_layout == RdfCloudTripleStoreConstants.TABLE_LAYOUT.OSP) {
            return super.buildRegex(subject, predicate, object, context, objectTypeInfo);
        }
        if (subject == null && predicate == null && object == null && context == null && objectTypeInfo == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String first = subject;
        String second = predicate;
        String third = object;
        if (table_layout == RdfCloudTripleStoreConstants.TABLE_LAYOUT.PO) {
            first = predicate;
            second = object;
            third = subject;
        }
        sb.append(HASHED_ALL_REGEX);
        if (first != null) {
            sb.append(first);
        } else {
            sb.append("([\\s\\S]*)");
        }
        sb.append("\u0000");
        if (second != null) {
            sb.append(second);
        } else {
            sb.append("([\\s\\S]*)");
        }
        sb.append("\u0000");
        if (third != null) {
            sb.append(third);
            if (objectTypeInfo == null) {
                sb.append(RdfCloudTripleStoreConstants.TYPE_DELIM);
                sb.append("([\\s\\S]*)");
            } else {
                sb.append(new String(objectTypeInfo, StandardCharsets.UTF_8));
            }
        } else {
            sb.append("([\\s\\S]*)");
            if (objectTypeInfo != null) {
                sb.append(new String(objectTypeInfo, StandardCharsets.UTF_8));
            }
        }
        return new TripleRowRegex(sb.toString(), context != null ? context + "([\\s\\S]*)" : null, null);
    }
}

