/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.query.strategy;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import org.apache.rya.api.RdfCloudTripleStoreConstants;
import org.apache.rya.api.query.strategy.TriplePatternStrategy;
import org.apache.rya.api.resolver.triple.TripleRowRegex;

public abstract class AbstractTriplePatternStrategy
implements TriplePatternStrategy {
    public static final String ALL_REGEX = "([\\s\\S]*)";

    @Override
    public abstract RdfCloudTripleStoreConstants.TABLE_LAYOUT getLayout();

    @Override
    public TripleRowRegex buildRegex(String subject, String predicate, String object, String context, byte[] objectTypeInfo) {
        RdfCloudTripleStoreConstants.TABLE_LAYOUT table_layout = this.getLayout();
        Preconditions.checkNotNull((Object)((Object)table_layout));
        if (subject == null && predicate == null && object == null && context == null && objectTypeInfo == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String first = subject;
        String second = predicate;
        String third = object;
        if (table_layout == RdfCloudTripleStoreConstants.TABLE_LAYOUT.PO) {
            first = predicate;
            second = object;
            third = subject;
        } else if (table_layout == RdfCloudTripleStoreConstants.TABLE_LAYOUT.OSP) {
            first = object;
            second = subject;
            third = predicate;
        }
        if (first != null) {
            sb.append(first);
        } else {
            sb.append(ALL_REGEX);
        }
        sb.append("\u0000");
        if (second != null) {
            sb.append(second);
        } else {
            sb.append(ALL_REGEX);
        }
        sb.append("\u0000");
        if (third != null) {
            sb.append(third);
            if (objectTypeInfo == null) {
                sb.append(RdfCloudTripleStoreConstants.TYPE_DELIM);
                sb.append(ALL_REGEX);
            } else {
                sb.append(new String(objectTypeInfo, StandardCharsets.UTF_8));
            }
        } else {
            sb.append(ALL_REGEX);
            if (objectTypeInfo != null) {
                sb.append(new String(objectTypeInfo, StandardCharsets.UTF_8));
            }
        }
        return new TripleRowRegex(sb.toString(), context != null ? context + ALL_REGEX : null, null);
    }
}

