/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.persist.utils;

import com.google.common.base.Preconditions;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.persist.RyaDAO;
import org.apache.rya.api.persist.utils.RyaDAOHelper;
import org.apache.rya.api.resolver.RyaToRdfConversions;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.rio.RDFHandler;

public class RyaDaoQueryWrapper {
    private final RyaDAO<?> ryaDao;
    private final RdfCloudTripleStoreConfiguration conf;

    public RyaDaoQueryWrapper(RyaDAO<?> ryaDao, RdfCloudTripleStoreConfiguration conf) {
        this.ryaDao = (RyaDAO)Preconditions.checkNotNull(ryaDao);
        this.conf = (RdfCloudTripleStoreConfiguration)((Object)Preconditions.checkNotNull((Object)((Object)conf)));
    }

    public RyaDaoQueryWrapper(RyaDAO<?> ryaDao) {
        this((RyaDAO)Preconditions.checkNotNull(ryaDao), (RdfCloudTripleStoreConfiguration)((Object)ryaDao.getConf()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void queryAll(Resource subject, IRI predicate, Value object, RDFHandler rdfStatementHandler, Resource ... contexts) throws QueryEvaluationException {
        Preconditions.checkNotNull((Object)rdfStatementHandler);
        try (CloseableIteration<Statement, QueryEvaluationException> iter = RyaDAOHelper.query(this.ryaDao, subject, predicate, object, this.conf, contexts);){
            while (iter.hasNext()) {
                Statement statement = (Statement)iter.next();
                try {
                    rdfStatementHandler.handleStatement(statement);
                }
                catch (Exception e) {
                    throw new QueryEvaluationException("Error handling statement.", (Throwable)e);
                    return;
                }
            }
        }
    }

    public void queryAll(Statement statement, RDFHandler rdfStatementHandler) throws QueryEvaluationException {
        Resource subject = statement.getSubject();
        IRI predicate = statement.getPredicate();
        Value object = statement.getObject();
        Resource context = statement.getContext();
        this.queryAll(subject, predicate, object, rdfStatementHandler, context);
    }

    public void queryAll(RyaStatement ryaStatement, RDFHandler rdfStatementHandler) throws QueryEvaluationException {
        Preconditions.checkNotNull((Object)ryaStatement);
        Statement statement = RyaToRdfConversions.convertStatement(ryaStatement);
        this.queryAll(statement, rdfStatementHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryFirst(Resource subject, IRI predicate, Value object, RDFHandler rdfStatementHandler, Resource ... contexts) throws QueryEvaluationException {
        block6: {
            Preconditions.checkNotNull((Object)rdfStatementHandler);
            try (CloseableIteration<Statement, QueryEvaluationException> iter = RyaDAOHelper.query(this.ryaDao, subject, predicate, object, this.conf, contexts);){
                if (!iter.hasNext()) break block6;
                Statement statement = (Statement)iter.next();
                try {
                    rdfStatementHandler.handleStatement(statement);
                }
                catch (Exception e) {
                    throw new QueryEvaluationException("Error handling statement.", (Throwable)e);
                }
            }
        }
    }

    public void queryFirst(Statement statement, RDFHandler rdfStatementHandler) throws QueryEvaluationException {
        Preconditions.checkNotNull((Object)statement);
        Resource subject = statement.getSubject();
        IRI predicate = statement.getPredicate();
        Value object = statement.getObject();
        Resource context = statement.getContext();
        this.queryFirst(subject, predicate, object, rdfStatementHandler, context);
    }

    public void queryFirst(RyaStatement ryaStatement, RDFHandler rdfStatementHandler) throws QueryEvaluationException {
        Preconditions.checkNotNull((Object)ryaStatement);
        Statement statement = RyaToRdfConversions.convertStatement(ryaStatement);
        this.queryFirst(statement, rdfStatementHandler);
    }
}

