/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.persist.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.RdfCloudTripleStoreUtils;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.persist.RyaDAO;
import org.apache.rya.api.persist.RyaDAOException;
import org.apache.rya.api.resolver.RdfToRyaConversions;
import org.apache.rya.api.resolver.RyaToRdfConversions;
import org.apache.rya.api.utils.NullableStatementImpl;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;

public class RyaDAOHelper {
    public static CloseableIteration<Statement, QueryEvaluationException> query(RyaDAO ryaDAO, Resource subject, IRI predicate, Value object, RdfCloudTripleStoreConfiguration conf, Resource ... contexts) throws QueryEvaluationException {
        return RyaDAOHelper.query(ryaDAO, new NullableStatementImpl(subject, predicate, object, contexts), conf);
    }

    public static CloseableIteration<Statement, QueryEvaluationException> query(RyaDAO ryaDAO, Statement stmt, RdfCloudTripleStoreConfiguration conf) throws QueryEvaluationException {
        CloseableIteration<RyaStatement, RyaDAOException> query;
        try {
            query = ryaDAO.getQueryEngine().query(RdfToRyaConversions.convertStatement(stmt), conf);
        }
        catch (RyaDAOException e) {
            throw new QueryEvaluationException((Throwable)e);
        }
        return new CloseableIteration<Statement, QueryEvaluationException>(){
            private boolean isClosed = false;

            public void close() throws QueryEvaluationException {
                try {
                    this.isClosed = true;
                    query.close();
                }
                catch (RyaDAOException e) {
                    throw new QueryEvaluationException((Throwable)e);
                }
            }

            public boolean hasNext() throws QueryEvaluationException {
                try {
                    return query.hasNext();
                }
                catch (RyaDAOException e) {
                    throw new QueryEvaluationException((Throwable)e);
                }
            }

            public Statement next() throws QueryEvaluationException {
                if (!this.hasNext() || this.isClosed) {
                    throw new NoSuchElementException();
                }
                try {
                    RyaStatement next = (RyaStatement)query.next();
                    if (next == null) {
                        return null;
                    }
                    return RyaToRdfConversions.convertStatement(next);
                }
                catch (RyaDAOException e) {
                    throw new QueryEvaluationException((Throwable)e);
                }
            }

            public void remove() throws QueryEvaluationException {
                try {
                    query.remove();
                }
                catch (RyaDAOException e) {
                    throw new QueryEvaluationException((Throwable)e);
                }
            }
        };
    }

    public static CloseableIteration<? extends Map.Entry<Statement, BindingSet>, QueryEvaluationException> query(RyaDAO ryaDAO, Collection<Map.Entry<Statement, BindingSet>> statements, RdfCloudTripleStoreConfiguration conf) throws QueryEvaluationException {
        CloseableIteration<Map.Entry<RyaStatement, BindingSet>, RyaDAOException> query;
        ArrayList<Map.Entry<RyaStatement, BindingSet>> ryaStatements = new ArrayList<Map.Entry<RyaStatement, BindingSet>>(statements.size());
        for (Map.Entry<Statement, BindingSet> entry : statements) {
            ryaStatements.add(new RdfCloudTripleStoreUtils.CustomEntry<RyaStatement, BindingSet>(RdfToRyaConversions.convertStatement(entry.getKey()), entry.getValue()));
        }
        try {
            query = ryaDAO.getQueryEngine().queryWithBindingSet(ryaStatements, conf);
        }
        catch (RyaDAOException e) {
            throw new QueryEvaluationException((Throwable)e);
        }
        return new CloseableIteration<Map.Entry<Statement, BindingSet>, QueryEvaluationException>(){
            private boolean isClosed = false;

            public void close() throws QueryEvaluationException {
                this.isClosed = true;
                try {
                    query.close();
                }
                catch (RyaDAOException e) {
                    throw new QueryEvaluationException((Throwable)e);
                }
            }

            public boolean hasNext() throws QueryEvaluationException {
                try {
                    return query.hasNext();
                }
                catch (RyaDAOException e) {
                    throw new QueryEvaluationException((Throwable)e);
                }
            }

            public Map.Entry<Statement, BindingSet> next() throws QueryEvaluationException {
                if (!this.hasNext() || this.isClosed) {
                    throw new NoSuchElementException();
                }
                try {
                    Map.Entry next = (Map.Entry)query.next();
                    if (next == null) {
                        return null;
                    }
                    return new RdfCloudTripleStoreUtils.CustomEntry<Statement, BindingSet>(RyaToRdfConversions.convertStatement((RyaStatement)next.getKey()), (BindingSet)next.getValue());
                }
                catch (RyaDAOException e) {
                    throw new QueryEvaluationException((Throwable)e);
                }
            }

            public void remove() throws QueryEvaluationException {
                try {
                    query.remove();
                }
                catch (RyaDAOException e) {
                    throw new QueryEvaluationException((Throwable)e);
                }
            }
        };
    }
}

