/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.persist.query.join;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Map;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaIRIRange;
import org.apache.rya.api.domain.RyaRange;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.api.persist.RyaDAOException;
import org.apache.rya.api.persist.query.RyaQueryEngine;
import org.apache.rya.api.persist.query.join.Join;
import org.apache.rya.api.resolver.RyaContext;
import org.apache.rya.api.utils.PeekingCloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;

public class MergeJoin<C extends RdfCloudTripleStoreConfiguration>
implements Join<C> {
    private RyaContext ryaContext = RyaContext.getInstance();
    private RyaQueryEngine ryaQueryEngine;

    public MergeJoin() {
    }

    public MergeJoin(RyaQueryEngine ryaQueryEngine) {
        this.ryaQueryEngine = ryaQueryEngine;
    }

    @Override
    public CloseableIteration<RyaStatement, RyaDAOException> join(C conf, RyaIRI ... preds) throws RyaDAOException {
        Preconditions.checkNotNull((Object)preds);
        Preconditions.checkArgument((preds.length > 1 ? 1 : 0) != 0, (Object)"Must join 2 or more");
        final ArrayList<CloseableIteration<RyaStatement, RyaDAOException>> iters = new ArrayList<CloseableIteration<RyaStatement, RyaDAOException>>();
        for (RyaIRI predicate : preds) {
            Preconditions.checkArgument((predicate != null && !(predicate instanceof RyaRange) ? 1 : 0) != 0);
            CloseableIteration<RyaStatement, RyaDAOException> iter = this.ryaQueryEngine.query(new RyaStatement(null, predicate, null), conf);
            iters.add(iter);
        }
        Preconditions.checkArgument((iters.size() > 1 ? 1 : 0) != 0, (Object)"Must join 2 or more");
        final CloseableIteration first = (CloseableIteration)iters.remove(0);
        return new CloseableIteration<RyaStatement, RyaDAOException>(){
            private RyaStatement first_stmt;
            private RyaType first_obj;

            public void close() throws RyaDAOException {
                for (CloseableIteration iter : iters) {
                    iter.close();
                }
            }

            public boolean hasNext() throws RyaDAOException {
                return this.first_stmt != null || this.check();
            }

            public RyaStatement next() throws RyaDAOException {
                if (this.first_stmt != null) {
                    RyaStatement temp = this.first_stmt;
                    this.first_stmt = null;
                    return temp;
                }
                if (this.check()) {
                    RyaStatement temp = this.first_stmt;
                    this.first_stmt = null;
                    return temp;
                }
                return null;
            }

            public void remove() throws RyaDAOException {
                this.next();
            }

            protected boolean check() throws RyaDAOException {
                if (!first.hasNext()) {
                    return false;
                }
                this.first_stmt = (RyaStatement)first.next();
                this.first_obj = this.first_stmt.getObject();
                for (CloseableIteration iter : iters) {
                    if (!iter.hasNext()) {
                        return false;
                    }
                    RyaType iter_obj = ((RyaStatement)iter.next()).getObject();
                    while (this.first_obj.compareTo(iter_obj) < 0) {
                        if (!first.hasNext()) {
                            return false;
                        }
                        this.first_obj = ((RyaStatement)first.next()).getObject();
                    }
                    while (this.first_obj.compareTo(iter_obj) > 0) {
                        if (!iter.hasNext()) {
                            return false;
                        }
                        iter_obj = ((RyaStatement)iter.next()).getObject();
                    }
                }
                return true;
            }
        };
    }

    @Override
    public CloseableIteration<RyaIRI, RyaDAOException> join(C conf, Map.Entry<RyaIRI, RyaType> ... predObjs) throws RyaDAOException {
        Preconditions.checkNotNull(predObjs);
        Preconditions.checkArgument((predObjs.length > 1 ? 1 : 0) != 0, (Object)"Must join 2 or more");
        final ArrayList<PeekingCloseableIteration<RyaStatement, RyaDAOException>> iters = new ArrayList<PeekingCloseableIteration<RyaStatement, RyaDAOException>>();
        RyaIRI earliest_subject = null;
        for (Map.Entry<RyaIRI, RyaType> predObj : predObjs) {
            RyaIRI predicate = predObj.getKey();
            RyaType object = predObj.getValue();
            Preconditions.checkArgument((predicate != null && !(predicate instanceof RyaRange) ? 1 : 0) != 0);
            Preconditions.checkArgument((object != null && !(object instanceof RyaRange) ? 1 : 0) != 0);
            PeekingCloseableIteration<RyaStatement, RyaDAOException> iter = null;
            iter = earliest_subject == null ? new PeekingCloseableIteration<RyaStatement, RyaDAOException>(this.ryaQueryEngine.query(new RyaStatement(null, predicate, object), conf)) : new PeekingCloseableIteration<RyaStatement, RyaDAOException>(this.ryaQueryEngine.query(new RyaStatement(new RyaIRIRange(earliest_subject, RyaIRIRange.LAST_IRI), predicate, object), conf));
            if (!iter.hasNext()) {
                return new EmptyIteration();
            }
            earliest_subject = iter.peek().getSubject();
            iters.add(iter);
        }
        Preconditions.checkArgument((iters.size() > 1 ? 1 : 0) != 0, (Object)"Must join 2 or more");
        final CloseableIteration first = (CloseableIteration)iters.remove(0);
        return new CloseableIteration<RyaIRI, RyaDAOException>(){
            private RyaIRI first_subj;

            public void close() throws RyaDAOException {
                for (CloseableIteration iter : iters) {
                    iter.close();
                }
            }

            public boolean hasNext() throws RyaDAOException {
                return this.first_subj != null || this.check();
            }

            public RyaIRI next() throws RyaDAOException {
                if (this.first_subj != null) {
                    RyaIRI temp = this.first_subj;
                    this.first_subj = null;
                    return temp;
                }
                if (this.check()) {
                    RyaIRI temp = this.first_subj;
                    this.first_subj = null;
                    return temp;
                }
                return null;
            }

            public void remove() throws RyaDAOException {
                this.next();
            }

            protected boolean check() throws RyaDAOException {
                if (!first.hasNext()) {
                    return false;
                }
                this.first_subj = ((RyaStatement)first.next()).getSubject();
                for (CloseableIteration iter : iters) {
                    if (!iter.hasNext()) {
                        return false;
                    }
                    RyaIRI iter_subj = ((RyaStatement)iter.next()).getSubject();
                    while (this.first_subj.compareTo(iter_subj) < 0) {
                        if (!first.hasNext()) {
                            return false;
                        }
                        this.first_subj = ((RyaStatement)first.next()).getSubject();
                    }
                    while (this.first_subj.compareTo(iter_subj) > 0) {
                        if (!iter.hasNext()) {
                            return false;
                        }
                        iter_subj = ((RyaStatement)iter.next()).getSubject();
                    }
                }
                return true;
            }
        };
    }

    public RyaQueryEngine getRyaQueryEngine() {
        return this.ryaQueryEngine;
    }

    public void setRyaQueryEngine(RyaQueryEngine ryaQueryEngine) {
        this.ryaQueryEngine = ryaQueryEngine;
    }
}

