/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.persist.query.join;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Map;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.RdfCloudTripleStoreUtils;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.api.persist.RyaDAOException;
import org.apache.rya.api.persist.query.RyaQueryEngine;
import org.apache.rya.api.persist.query.join.Join;
import org.apache.rya.api.resolver.RyaContext;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.ConvertingIteration;
import org.eclipse.rdf4j.query.BindingSet;

public class IterativeJoin<C extends RdfCloudTripleStoreConfiguration>
implements Join<C> {
    private RyaContext ryaContext = RyaContext.getInstance();
    private RyaQueryEngine ryaQueryEngine;

    public IterativeJoin() {
    }

    public IterativeJoin(RyaQueryEngine ryaQueryEngine) {
        this.ryaQueryEngine = ryaQueryEngine;
    }

    @Override
    public CloseableIteration<RyaStatement, RyaDAOException> join(C conf, RyaIRI ... preds) throws RyaDAOException {
        Preconditions.checkNotNull((Object)preds);
        Preconditions.checkArgument((preds.length > 1 ? 1 : 0) != 0, (Object)"Must join 2 or more");
        CloseableIteration<RyaStatement, RyaDAOException> iter = null;
        for (RyaIRI pred : preds) {
            iter = iter == null ? this.ryaQueryEngine.query(new RyaStatement(null, pred, null), null) : this.join(iter, pred);
        }
        return iter;
    }

    @Override
    public CloseableIteration<RyaIRI, RyaDAOException> join(C conf, Map.Entry<RyaIRI, RyaType> ... predObjs) throws RyaDAOException {
        Preconditions.checkNotNull(predObjs);
        Preconditions.checkArgument((predObjs.length > 1 ? 1 : 0) != 0, (Object)"Must join 2 or more");
        CloseableIteration<RyaStatement, RyaDAOException> first = null;
        CloseableIteration<RyaIRI, RyaDAOException> iter = null;
        for (Map.Entry<RyaIRI, RyaType> entry : predObjs) {
            if (first == null) {
                first = this.ryaQueryEngine.query(new RyaStatement(null, entry.getKey(), entry.getValue()), null);
                continue;
            }
            iter = iter == null ? this.join((CloseableIteration<RyaIRI, RyaDAOException>)new ConvertingIteration<RyaStatement, RyaIRI, RyaDAOException>(first){

                protected RyaIRI convert(RyaStatement statement) throws RyaDAOException {
                    return statement.getSubject();
                }
            }, entry) : this.join(iter, entry);
        }
        return iter;
    }

    protected CloseableIteration<RyaIRI, RyaDAOException> join(final CloseableIteration<RyaIRI, RyaDAOException> iteration, final Map.Entry<RyaIRI, RyaType> predObj) {
        int batch = 100;
        return new CloseableIteration<RyaIRI, RyaDAOException>(){
            private CloseableIteration<Map.Entry<RyaStatement, BindingSet>, RyaDAOException> query;

            public void close() throws RyaDAOException {
                iteration.close();
                if (this.query != null) {
                    this.query.close();
                }
            }

            public boolean hasNext() throws RyaDAOException {
                return this.query != null && this.query.hasNext() || this.batchNext();
            }

            public RyaIRI next() throws RyaDAOException {
                if (!(this.query != null && this.query.hasNext() || this.batchNext())) {
                    return null;
                }
                if (this.query != null && this.query.hasNext()) {
                    return ((RyaStatement)((Map.Entry)this.query.next()).getKey()).getSubject();
                }
                return null;
            }

            private boolean batchNext() throws RyaDAOException {
                if (!iteration.hasNext()) {
                    return false;
                }
                ArrayList<Map.Entry<RyaStatement, BindingSet>> batchedResults = new ArrayList<Map.Entry<RyaStatement, BindingSet>>();
                for (int i = 0; i < 100 && iteration.hasNext(); ++i) {
                    batchedResults.add(new RdfCloudTripleStoreUtils.CustomEntry<RyaStatement, Object>(new RyaStatement((RyaIRI)iteration.next(), (RyaIRI)predObj.getKey(), (RyaType)predObj.getValue()), null));
                }
                this.query = IterativeJoin.this.ryaQueryEngine.queryWithBindingSet(batchedResults, null);
                return this.query.hasNext();
            }

            public void remove() throws RyaDAOException {
                this.next();
            }
        };
    }

    protected CloseableIteration<RyaStatement, RyaDAOException> join(final CloseableIteration<RyaStatement, RyaDAOException> iteration, final RyaIRI pred) {
        int batch = 100;
        return new CloseableIteration<RyaStatement, RyaDAOException>(){
            private CloseableIteration<Map.Entry<RyaStatement, BindingSet>, RyaDAOException> query;

            public void close() throws RyaDAOException {
                iteration.close();
                if (this.query != null) {
                    this.query.close();
                }
            }

            public boolean hasNext() throws RyaDAOException {
                return this.query != null && this.query.hasNext() || this.batchNext();
            }

            public RyaStatement next() throws RyaDAOException {
                if (!(this.query != null && this.query.hasNext() || this.batchNext())) {
                    return null;
                }
                if (this.query != null && this.query.hasNext()) {
                    return (RyaStatement)((Map.Entry)this.query.next()).getKey();
                }
                return null;
            }

            private boolean batchNext() throws RyaDAOException {
                if (!iteration.hasNext()) {
                    return false;
                }
                ArrayList<Map.Entry<RyaStatement, BindingSet>> batchedResults = new ArrayList<Map.Entry<RyaStatement, BindingSet>>();
                for (int i = 0; i < 100 && iteration.hasNext(); ++i) {
                    RyaStatement next = (RyaStatement)iteration.next();
                    batchedResults.add(new RdfCloudTripleStoreUtils.CustomEntry<RyaStatement, Object>(new RyaStatement(next.getSubject(), pred, next.getObject()), null));
                }
                this.query = IterativeJoin.this.ryaQueryEngine.queryWithBindingSet(batchedResults, null);
                return this.query.hasNext();
            }

            public void remove() throws RyaDAOException {
                this.next();
            }
        };
    }

    public RyaQueryEngine getRyaQueryEngine() {
        return this.ryaQueryEngine;
    }

    public void setRyaQueryEngine(RyaQueryEngine ryaQueryEngine) {
        this.ryaQueryEngine = ryaQueryEngine;
    }
}

