/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.persist.query.join;

import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.RdfCloudTripleStoreUtils;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.api.persist.RyaDAOException;
import org.apache.rya.api.persist.query.RyaQueryEngine;
import org.apache.rya.api.persist.query.join.Join;
import org.apache.rya.api.resolver.RyaContext;
import org.apache.rya.api.utils.EnumerationWrapper;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;

public class HashJoin<C extends RdfCloudTripleStoreConfiguration>
implements Join<C> {
    private RyaContext ryaContext = RyaContext.getInstance();
    private RyaQueryEngine ryaQueryEngine;

    public HashJoin() {
    }

    public HashJoin(RyaQueryEngine ryaQueryEngine) {
        this.ryaQueryEngine = ryaQueryEngine;
    }

    @Override
    public CloseableIteration<RyaStatement, RyaDAOException> join(C conf, RyaIRI ... preds) throws RyaDAOException {
        ConcurrentHashMap<RdfCloudTripleStoreUtils.CustomEntry<RyaIRI, RyaType>, Integer> ht = new ConcurrentHashMap<RdfCloudTripleStoreUtils.CustomEntry<RyaIRI, RyaType>, Integer>();
        int count = 0;
        boolean first = true;
        for (RyaIRI pred : preds) {
            ++count;
            CloseableIteration<RyaStatement, RyaDAOException> results = this.ryaQueryEngine.query(new RyaStatement(null, pred, null), null);
            while (results.hasNext()) {
                RyaStatement next = (RyaStatement)results.next();
                RyaIRI subject = next.getSubject();
                RyaType object = next.getObject();
                RdfCloudTripleStoreUtils.CustomEntry<RyaIRI, RyaType> entry = new RdfCloudTripleStoreUtils.CustomEntry<RyaIRI, RyaType>(subject, object);
                if (!first && !ht.containsKey(entry)) continue;
                ht.put(entry, count);
            }
            if (first) {
                first = false;
                continue;
            }
            for (Map.Entry entry : ht.entrySet()) {
                if ((Integer)entry.getValue() >= count) continue;
                ht.remove(entry.getKey());
            }
        }
        final Enumeration keys = ht.keys();
        return new CloseableIteration<RyaStatement, RyaDAOException>(){

            public void close() throws RyaDAOException {
            }

            public boolean hasNext() throws RyaDAOException {
                return keys.hasMoreElements();
            }

            public RyaStatement next() throws RyaDAOException {
                Map.Entry subjObj = (Map.Entry)keys.nextElement();
                return new RyaStatement((RyaIRI)subjObj.getKey(), null, (RyaType)subjObj.getValue());
            }

            public void remove() throws RyaDAOException {
                keys.nextElement();
            }
        };
    }

    @Override
    public CloseableIteration<RyaIRI, RyaDAOException> join(C conf, Map.Entry<RyaIRI, RyaType> ... predObjs) throws RyaDAOException {
        ConcurrentHashMap<RyaIRI, Integer> ht = new ConcurrentHashMap<RyaIRI, Integer>();
        int count = 0;
        boolean first = true;
        for (Map.Entry<RyaIRI, RyaType> predObj : predObjs) {
            ++count;
            RyaIRI pred = predObj.getKey();
            RyaType obj = predObj.getValue();
            CloseableIteration<RyaStatement, RyaDAOException> results = this.ryaQueryEngine.query(new RyaStatement(null, pred, obj), null);
            while (results.hasNext()) {
                RyaIRI subject = ((RyaStatement)results.next()).getSubject();
                if (!first && !ht.containsKey(subject)) continue;
                ht.put(subject, count);
            }
            if (first) {
                first = false;
                continue;
            }
            for (Map.Entry entry : ht.entrySet()) {
                if ((Integer)entry.getValue() >= count) continue;
                ht.remove(entry.getKey());
            }
        }
        return new EnumerationWrapper<RyaIRI, RyaDAOException>(ht.keys());
    }

    public RyaQueryEngine getRyaQueryEngine() {
        return this.ryaQueryEngine;
    }

    public void setRyaQueryEngine(RyaQueryEngine ryaQueryEngine) {
        this.ryaQueryEngine = ryaQueryEngine;
    }
}

