/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.persist.query;

import java.util.Arrays;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RyaQueryOptions {
    private static final Logger logger = LoggerFactory.getLogger(RyaQueryOptions.class);
    protected String[] auths;
    protected Long ttl;
    protected Long currentTime;
    protected Long maxResults;
    protected Integer numQueryThreads = 4;
    protected Integer batchSize = 1000;
    protected String regexSubject;
    protected String regexPredicate;
    protected String regexObject;
    protected RdfCloudTripleStoreConfiguration conf;

    public RdfCloudTripleStoreConfiguration getConf() {
        return this.conf;
    }

    public void setConf(RdfCloudTripleStoreConfiguration conf) {
        this.conf = conf;
    }

    public Long getTtl() {
        return this.ttl;
    }

    public void setTtl(Long ttl) {
        this.ttl = ttl;
    }

    public Long getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(Long currentTime) {
        this.currentTime = currentTime;
    }

    public Integer getNumQueryThreads() {
        return this.numQueryThreads;
    }

    public void setNumQueryThreads(Integer numQueryThreads) {
        this.numQueryThreads = numQueryThreads;
    }

    public Long getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public String getRegexSubject() {
        return this.regexSubject;
    }

    public void setRegexSubject(String regexSubject) {
        this.regexSubject = regexSubject;
    }

    public String getRegexPredicate() {
        return this.regexPredicate;
    }

    public void setRegexPredicate(String regexPredicate) {
        this.regexPredicate = regexPredicate;
    }

    public String getRegexObject() {
        return this.regexObject;
    }

    public void setRegexObject(String regexObject) {
        this.regexObject = regexObject;
    }

    public String[] getAuths() {
        return this.auths;
    }

    public void setAuths(String[] auths) {
        this.auths = auths == null ? new String[0] : (String[])auths.clone();
    }

    public String toString() {
        return "RyaQueryOptions{auths=" + (this.auths == null ? null : Arrays.asList(this.auths)) + ", ttl=" + this.ttl + ", currentTime=" + this.currentTime + ", maxResults=" + this.maxResults + ", numQueryThreads=" + this.numQueryThreads + ", batchSize=" + this.batchSize + ", regexSubject='" + this.regexSubject + '\'' + ", regexPredicate='" + this.regexPredicate + '\'' + ", regexObject='" + this.regexObject + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RyaQueryOptions that = (RyaQueryOptions)o;
        if (!Arrays.equals(this.auths, that.auths)) {
            return false;
        }
        if (this.batchSize != null ? !this.batchSize.equals(that.batchSize) : that.batchSize != null) {
            return false;
        }
        if (this.currentTime != null ? !this.currentTime.equals(that.currentTime) : that.currentTime != null) {
            return false;
        }
        if (this.maxResults != null ? !this.maxResults.equals(that.maxResults) : that.maxResults != null) {
            return false;
        }
        if (this.numQueryThreads != null ? !this.numQueryThreads.equals(that.numQueryThreads) : that.numQueryThreads != null) {
            return false;
        }
        if (this.regexObject != null ? !this.regexObject.equals(that.regexObject) : that.regexObject != null) {
            return false;
        }
        if (this.regexPredicate != null ? !this.regexPredicate.equals(that.regexPredicate) : that.regexPredicate != null) {
            return false;
        }
        if (this.regexSubject != null ? !this.regexSubject.equals(that.regexSubject) : that.regexSubject != null) {
            return false;
        }
        return this.ttl != null ? this.ttl.equals(that.ttl) : that.ttl == null;
    }

    public int hashCode() {
        int result = this.auths != null ? Arrays.hashCode(this.auths) : 0;
        result = 31 * result + (this.ttl != null ? this.ttl.hashCode() : 0);
        result = 31 * result + (this.currentTime != null ? this.currentTime.hashCode() : 0);
        result = 31 * result + (this.maxResults != null ? this.maxResults.hashCode() : 0);
        result = 31 * result + (this.numQueryThreads != null ? this.numQueryThreads.hashCode() : 0);
        result = 31 * result + (this.batchSize != null ? this.batchSize.hashCode() : 0);
        result = 31 * result + (this.regexSubject != null ? this.regexSubject.hashCode() : 0);
        result = 31 * result + (this.regexPredicate != null ? this.regexPredicate.hashCode() : 0);
        result = 31 * result + (this.regexObject != null ? this.regexObject.hashCode() : 0);
        return result;
    }

    public static class RyaOptionsBuilder<T extends RyaOptionsBuilder> {
        private RyaQueryOptions options;

        public RyaOptionsBuilder(RyaQueryOptions query) {
            this.options = query;
        }

        public T load(RdfCloudTripleStoreConfiguration conf) {
            this.options.setConf(conf);
            return ((RyaOptionsBuilder)((RyaOptionsBuilder)((RyaOptionsBuilder)((RyaOptionsBuilder)((RyaOptionsBuilder)((RyaOptionsBuilder)((RyaOptionsBuilder)((RyaOptionsBuilder)this.setAuths(conf.getAuths())).setBatchSize(conf.getBatchSize())).setCurrentTime(conf.getStartTime())).setMaxResults(conf.getLimit())).setNumQueryThreads(conf.getNumThreads())).setRegexObject(conf.getRegexObject())).setRegexPredicate(conf.getRegexPredicate())).setRegexSubject(conf.getRegexSubject())).setTtl(conf.getTtl());
        }

        public T setAuths(String[] auths) {
            this.options.setAuths(auths);
            return (T)this;
        }

        public T setRegexObject(String regexObject) {
            this.options.setRegexObject(regexObject);
            return (T)this;
        }

        public T setRegexPredicate(String regexPredicate) {
            this.options.setRegexPredicate(regexPredicate);
            return (T)this;
        }

        public T setRegexSubject(String regexSubject) {
            this.options.setRegexSubject(regexSubject);
            return (T)this;
        }

        public T setBatchSize(Integer batchSize) {
            this.options.setBatchSize(batchSize);
            return (T)this;
        }

        public T setNumQueryThreads(Integer numQueryThreads) {
            this.options.setNumQueryThreads(numQueryThreads);
            return (T)this;
        }

        public T setMaxResults(Long maxResults) {
            this.options.setMaxResults(maxResults);
            return (T)this;
        }

        public T setCurrentTime(Long currentTime) {
            this.options.setCurrentTime(currentTime);
            return (T)this;
        }

        public T setTtl(Long ttl) {
            this.options.setTtl(ttl);
            return (T)this;
        }
    }
}

